/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.dialogs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.panels.BranchSelectSimpleComposite;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.ote.ui.define.OteDefineImage;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class BranchComboDialog
extends TitleAreaDialog
implements Listener {
    private static final Image TITLE_BAR_IMAGE = ImageManager.getImage((KeyedImage)OteDefineImage.CHILD_BRANCH);
    private static final Image MESSAGE_IMAGE = ImageManager.getImage((KeyedImage)OteDefineImage.COMMIT_WIZ);
    private static final String MESSAGE_TITLE = "Select a Working Branch";
    private static final String TITLE_BAR_TEXT = "Working Branch";
    private static final String MESSAGE = "Select a working branch";
    protected static final int COMBO_HISTORY_LENGTH = 5;
    private BranchSelectSimpleComposite branchSelectComposite;

    private BranchComboDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = (Composite)super.createDialogArea(parent);
        this.branchSelectComposite = new BranchSelectSimpleComposite(content, 0);
        this.restoreWidgetValues();
        this.branchSelectComposite.addListener((Listener)this);
        this.setTitle(MESSAGE_TITLE);
        this.setTitleImage(MESSAGE_IMAGE);
        this.setMessage(MESSAGE);
        this.getShell().setText(TITLE_BAR_TEXT);
        this.getShell().setImage(TITLE_BAR_IMAGE);
        return this.branchSelectComposite;
    }

    protected Control createButtonBar(Composite parent) {
        Control toReturn = super.createButtonBar(parent);
        this.checkState();
        return toReturn;
    }

    public BranchToken getSelection() {
        return this.branchSelectComposite.getSelectedBranch();
    }

    private void checkState() {
        boolean isValid = this.getSelection().isValid();
        this.getButton(0).setEnabled(isValid);
        this.setErrorMessage(isValid ? null : "Branch cannot be empty.");
    }

    protected void okPressed() {
        this.saveWidgetValues();
        super.okPressed();
    }

    public void handleEvent(Event event) {
        this.checkState();
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = Activator.getInstance().getDialogSettings();
        if (settings != null) {
            String[] branchUuids = settings.getArray("all.branches.id");
            String lastSelected = settings.get("last.branch.id");
            this.branchSelectComposite.restoreWidgetValues(branchUuids, lastSelected);
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = Activator.getInstance().getDialogSettings();
        if (settings != null) {
            String[] branchUuids = settings.getArray("all.branches.id");
            if (branchUuids == null) {
                branchUuids = new String[]{};
            }
            try {
                BranchToken branch = this.getSelection();
                if (branch.isValid()) {
                    String lastBranchSelected = branch.getIdString();
                    ArrayList<String> history = new ArrayList<String>(Arrays.asList(branchUuids));
                    history.remove(lastBranchSelected);
                    history.add(0, lastBranchSelected);
                    if (history.size() > 5) {
                        history.remove(5);
                    }
                    branchUuids = new String[history.size()];
                    history.toArray(branchUuids);
                    settings.put("all.branches.id", branchUuids);
                    settings.put("last.branch.id", lastBranchSelected);
                    try {
                        settings.save(((Object)((Object)this)).getClass().getName());
                    }
                    catch (IOException ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
    }

    public static BranchToken getBranchFromUser() {
        BranchToken toReturn = BranchToken.SENTINEL;
        BranchComboDialog branchSelection = new BranchComboDialog(AWorkbench.getActiveShell());
        int result = branchSelection.open();
        if (result == 0) {
            toReturn = branchSelection.getSelection();
        }
        return toReturn;
    }
}

