/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workflow.note;

import java.util.Date;
import org.eclipse.osee.ats.api.workflow.note.AtsStateNoteXmlType;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsStateNoteXml {
    private Date date;
    private String state;
    private String msg;
    private UserToken user;
    private AtsStateNoteXmlType type;

    public AtsStateNoteXml(AtsStateNoteXmlType type, String state, String date, UserToken user, String msg) {
        Long l = Long.valueOf(date);
        this.date = new Date(l);
        this.state = Strings.intern((String)state);
        this.msg = msg;
        this.user = user;
        this.type = type;
    }

    public AtsStateNoteXml(String type, String state, String date, UserToken user, String msg) {
        this(AtsStateNoteXmlType.getType(type), state, date, user, msg);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String toString() {
        return String.format("%s from %s%s on %s - %s", new Object[]{this.type, this.user.getName(), this.toStringState(), DateUtil.getMMDDYYHHMM((Date)this.date), this.msg});
    }

    private String toStringState() {
        return this.state.isEmpty() ? "" : " for \"" + this.state + "\"";
    }

    public UserToken getUser() {
        return this.user;
    }

    public AtsStateNoteXmlType getType() {
        return this.type;
    }

    public String toHTML() {
        return this.toString().replaceFirst("^Note: ", "<b>Note:</b>");
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setUser(UserToken user) {
        this.user = user;
    }

    public void setType(AtsStateNoteXmlType type) {
        this.type = type;
    }
}

