/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt.hex;

import org.eclipse.swt.graphics.Color;

public class HexTableRow {
    public final int offset;
    public int length;
    public byte[] array;
    private final Color[] backgroundColor;
    private final boolean[] displayAsAscii;
    private static final String[] hexTbl = new String[256];

    static {
        int i = 0;
        while (i < 256) {
            HexTableRow.hexTbl[i] = String.format("%02X", i);
            ++i;
        }
    }

    public HexTableRow(int offset, int length, byte[] array) {
        this.offset = offset;
        this.array = array;
        this.length = length;
        this.backgroundColor = new Color[length];
        this.displayAsAscii = new boolean[length];
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getArray() {
        return this.array;
    }

    public void setArray(byte[] array) {
        this.array = array;
    }

    public String getHex(int column) {
        byte b = this.array[this.offset + column];
        return hexTbl[b & 0xFF];
    }

    public String getAscii(int column) {
        byte b = this.array[this.offset + column];
        if (b >= 32 && b < 127) {
            return new String(new byte[]{b});
        }
        return ".";
    }

    public String getText(int column) {
        if (this.displayAsAscii[column]) {
            return this.getAscii(column);
        }
        return this.getHex(column);
    }

    public String getBinary(int column) {
        byte b = this.array[this.offset + column];
        return Integer.toBinaryString(b & 0xFF);
    }

    public String getToolTip(int column) {
        return this.getBinary(column);
    }

    public String toString() {
        return super.toString();
    }

    public Color getBackgroundColor(int column) {
        return this.backgroundColor[column];
    }

    public void setBackgroundColor(int columnm, Color backgroundColor) {
        this.backgroundColor[columnm] = backgroundColor;
    }

    public void setDisplayAsAscii(int column, boolean displayAsAscii) {
        this.displayAsAscii[column] = displayAsAscii;
    }
}

