/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NonmodalWizardDialog
extends WizardDialog {
    private Button backButton;
    private Button nextButton;
    private Button finishButton;
    private Button cancelButton;
    private Button helpButton;
    private final IWizard wizard;
    private final SelectionAdapter cancelListener;
    private IWizardPage currentPage = null;

    public NonmodalWizardDialog(Shell shell, Wizard wizard) {
        super(new Shell(), (IWizard)wizard);
        this.setShellStyle(0x4CF0 | NonmodalWizardDialog.getDefaultOrientation());
        this.cancelListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NonmodalWizardDialog.this.cancelPressed();
            }
        };
        this.wizard = this.getWizard();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.wizard.isHelpAvailable()) {
            this.helpButton = this.createButton(parent, 17, IDialogConstants.HELP_LABEL, false);
        }
        if (this.wizard.needsPreviousAndNextButtons()) {
            this.createPreviousAndNextButtons(parent);
        }
        this.finishButton = this.createButton(parent, 16, IDialogConstants.FINISH_LABEL, true);
        this.cancelButton = this.createCancelButton(parent);
    }

    private Button createCancelButton(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(IDialogConstants.CANCEL_LABEL);
        this.setButtonLayoutData(button);
        button.setFont(parent.getFont());
        button.setData((Object)1);
        button.addSelectionListener((SelectionListener)this.cancelListener);
        return button;
    }

    private Composite createPreviousAndNextButtons(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(68);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.backButton = this.createButton(composite, 14, IDialogConstants.BACK_LABEL, false);
        this.nextButton = this.createButton(composite, 15, IDialogConstants.NEXT_LABEL, false);
        this.nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
            }
        });
        return composite;
    }

    public void updateButtons() {
        boolean canFlipToNextPage = false;
        boolean canFinish = this.wizard.canFinish();
        this.currentPage = this.getCurrentPage();
        if (this.backButton != null) {
            this.backButton.setEnabled(this.currentPage.getPreviousPage() != null);
        }
        if (this.nextButton != null) {
            canFlipToNextPage = this.currentPage.canFlipToNextPage();
            this.nextButton.setEnabled(canFlipToNextPage);
        }
        this.finishButton.setEnabled(canFinish);
        if (canFlipToNextPage && !canFinish) {
            this.getShell().setDefaultButton(this.nextButton);
        } else {
            this.getShell().setDefaultButton(this.finishButton);
        }
    }
}

