/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.FloatingPointNumberAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.error.ShouldBeEqual;
import org.assertj.core.error.ShouldNotBeEqual;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Floats;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractFloatAssert<SELF extends AbstractFloatAssert<SELF>>
extends AbstractComparableAssert<SELF, Float>
implements FloatingPointNumberAssert<SELF, Float> {
    private static final Float NEGATIVE_ZERO = Float.valueOf(-0.0f);
    @VisibleForTesting
    Floats floats = Floats.instance();
    private boolean isPrimitive;

    public AbstractFloatAssert(Float actual, Class<?> selfType) {
        super(actual, selfType);
        this.isPrimitive = false;
    }

    public AbstractFloatAssert(float actual, Class<?> selfType) {
        super(Float.valueOf(actual), selfType);
        this.isPrimitive = true;
    }

    @Override
    public SELF isNaN() {
        this.floats.assertIsNaN(this.info, (Float)this.actual);
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isNotNaN() {
        this.floats.assertIsNotNaN(this.info, (Float)this.actual);
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isZero() {
        if (this.isPrimitive) {
            this.assertIsPrimitiveZero();
        } else {
            this.floats.assertIsZero(this.info, (Float)this.actual);
        }
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    private void assertIsPrimitiveZero() {
        if (((Float)this.actual).floatValue() == 0.0f) {
            return;
        }
        throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqual.shouldBeEqual(this.actual, Float.valueOf(0.0f), this.info.representation()));
    }

    private void assertIsPrimitiveNonZero() {
        if ((double)((Float)this.actual).floatValue() != 0.0) {
            return;
        }
        throw Failures.instance().failure((AssertionInfo)this.info, ShouldNotBeEqual.shouldNotBeEqual(this.actual, 0.0));
    }

    @Override
    public SELF isNotZero() {
        if (this.isPrimitive) {
            this.assertIsPrimitiveNonZero();
        } else {
            if (NEGATIVE_ZERO.equals(this.actual)) {
                return (SELF)((AbstractFloatAssert)this.myself);
            }
            this.floats.assertIsNotZero(this.info, (Float)this.actual);
        }
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isOne() {
        this.floats.assertIsOne(this.info, (Float)this.actual);
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isPositive() {
        this.floats.assertIsPositive(this.info, (Float)this.actual);
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isNegative() {
        this.floats.assertIsNegative(this.info, (Float)this.actual);
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isNotNegative() {
        this.floats.assertIsNotNegative(this.info, (Float)this.actual);
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isNotPositive() {
        this.floats.assertIsNotPositive(this.info, (Float)this.actual);
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    public SELF isEqualTo(float expected) {
        this.floats.assertEqual(this.info, (Float)this.actual, Float.valueOf(expected));
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(float expected, Offset<Float> offset) {
        this.floats.assertIsCloseTo(this.info, (Float)this.actual, Float.valueOf(expected), offset);
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(float expected, Offset<Float> offset) {
        this.floats.assertIsNotCloseTo(this.info, (Float)this.actual, Float.valueOf(expected), offset);
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(Float expected, Offset<Float> offset) {
        this.floats.assertIsCloseTo(this.info, (Float)this.actual, expected, offset);
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(Float expected, Offset<Float> offset) {
        this.floats.assertIsNotCloseTo(this.info, (Float)this.actual, expected, offset);
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(Float expected, Percentage percentage) {
        this.floats.assertIsCloseToPercentage(this.info, (Float)this.actual, expected, percentage);
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(Float expected, Percentage percentage) {
        this.floats.assertIsNotCloseToPercentage(this.info, (Float)this.actual, expected, percentage);
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(float expected, Percentage percentage) {
        this.floats.assertIsCloseToPercentage(this.info, (Float)this.actual, Float.valueOf(expected), percentage);
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(float expected, Percentage percentage) {
        this.floats.assertIsNotCloseToPercentage(this.info, (Float)this.actual, Float.valueOf(expected), percentage);
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isEqualTo(Float expected, Offset<Float> offset) {
        this.floats.assertIsCloseTo(this.info, (Float)this.actual, expected, offset);
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isEqualTo(float expected, Offset<Float> offset) {
        this.floats.assertIsCloseTo(this.info, (Float)this.actual, Float.valueOf(expected), offset);
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    public SELF isNotEqualTo(float other) {
        this.floats.assertNotEqual(this.info, (Float)this.actual, Float.valueOf(other));
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isLessThan(float other) {
        this.floats.assertLessThan(this.info, (Float)this.actual, Float.valueOf(other));
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isLessThanOrEqualTo(float other) {
        this.floats.assertLessThanOrEqualTo(this.info, (Float)this.actual, Float.valueOf(other));
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isGreaterThan(float other) {
        this.floats.assertGreaterThan(this.info, (Float)this.actual, Float.valueOf(other));
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isGreaterThanOrEqualTo(float other) {
        this.floats.assertGreaterThanOrEqualTo(this.info, (Float)this.actual, Float.valueOf(other));
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isBetween(Float start, Float end) {
        this.floats.assertIsBetween(this.info, (Float)this.actual, start, end);
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    public SELF isStrictlyBetween(Float start, Float end) {
        this.floats.assertIsStrictlyBetween(this.info, (Float)this.actual, start, end);
        return (SELF)((AbstractFloatAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super Float> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super Float> customComparator, String customComparatorDescription) {
        this.floats = new Floats(new ComparatorBasedComparisonStrategy(customComparator, customComparatorDescription));
        return (SELF)((AbstractFloatAssert)super.usingComparator(customComparator, customComparatorDescription));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        this.floats = Floats.instance();
        return (SELF)((AbstractFloatAssert)super.usingDefaultComparator());
    }
}

