/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.IXViewerPreComputedColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsUtilClient;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.world.IWorldViewerEventHandler;
import org.eclipse.osee.ats.ide.world.WorldXViewer;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.event.model.EventModType;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.ui.swt.Displays;

public class WorldXViewerEventManager {
    private static final NotificationHandler notificationHandler = new NotificationHandler();

    private WorldXViewerEventManager() {
    }

    public static void add(IWorldViewerEventHandler iWorldEventHandler) {
        notificationHandler.add(iWorldEventHandler);
    }

    public static void remove(IWorldViewerEventHandler iWorldEventHandler) {
        notificationHandler.remove(iWorldEventHandler);
    }

    public static Collection<IWorldViewerEventHandler> getHandlers() {
        return WorldXViewerEventManager.notificationHandler.handlers;
    }

    private static final class DisplayRunnable
    implements Runnable {
        private final Collection<Artifact> modifiedArts;
        private final Collection<Artifact> relModifiedArts;
        private final Collection<EventBasicGuidArtifact> deletedPurgedArts;
        private final Collection<IWorldViewerEventHandler> handlers;
        private final Collection<Artifact> goalMemberReordered;
        private final Collection<Artifact> sprintMemberReordered;
        private final Collection<Artifact> allModAndParents;
        private final ArtifactEvent artifactEvent;

        public DisplayRunnable(Collection<Artifact> modifiedArts, Collection<Artifact> allModAndParents, Collection<Artifact> relModifiedArts, Collection<EventBasicGuidArtifact> deletedPurgedArts, Collection<Artifact> goalMemberReordered, Collection<Artifact> sprintMemberReordered, ArtifactEvent artifactEvent, Collection<IWorldViewerEventHandler> handlers) {
            this.modifiedArts = modifiedArts;
            this.allModAndParents = allModAndParents;
            this.relModifiedArts = relModifiedArts;
            this.deletedPurgedArts = deletedPurgedArts;
            this.goalMemberReordered = goalMemberReordered;
            this.sprintMemberReordered = sprintMemberReordered;
            this.artifactEvent = artifactEvent;
            this.handlers = handlers;
        }

        private void processArtifact(WorldXViewer worldViewer, Artifact artifact, Set<Long> processed) {
            try {
                if (!artifact.isDeleted() && AtsObjects.isAtsWorkItemOrAction((Object)artifact)) {
                    AbstractWorkflowArtifact smaArt;
                    Artifact smaParent;
                    worldViewer.refresh(artifact);
                    if (artifact instanceof AbstractWorkflowArtifact && (smaParent = (smaArt = (AbstractWorkflowArtifact)artifact).getParentAtsArtifact()) != null && !processed.contains(smaParent.getId())) {
                        worldViewer.refresh(smaParent);
                        processed.add(smaParent.getId());
                    }
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }

        private void updatePreComputedColumnValue(Collection<Artifact> allModAndParents, WorldXViewer worldViewer) {
            try {
                for (XViewerColumn column : worldViewer.getCustomizeMgr().getCurrentVisibleTableColumns()) {
                    if (!(column instanceof IXViewerPreComputedColumn)) continue;
                    ((IXViewerPreComputedColumn)column).populateCachedValues(allModAndParents, column.getPreComputedValueMap());
                }
            }
            catch (Exception exception) {}
        }

        private void processPurged(WorldXViewer worldViewer, IWorldViewerEventHandler handler) {
            if (!this.deletedPurgedArts.isEmpty()) {
                try {
                    worldViewer.refresh();
                }
                catch (Exception ex) {
                    OseeLog.logf(Activator.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Error processing event handler for deleted - %s", (Object[])new Object[]{handler});
                }
            }
        }

        @Override
        public void run() {
            HashSet<Long> processed = new HashSet<Long>();
            for (IWorldViewerEventHandler handler : this.handlers) {
                try {
                    WorldXViewer worldViewer;
                    if (handler.isDisposed() || (worldViewer = handler.getWorldXViewer()) == null || worldViewer.isDisposed()) continue;
                    this.updatePreComputedColumnValue(this.allModAndParents, worldViewer);
                    this.processPurged(worldViewer, handler);
                    for (Artifact artifact : this.modifiedArts) {
                        this.processArtifact(worldViewer, artifact, processed);
                    }
                    for (Artifact artifact : this.relModifiedArts) {
                        this.processArtifact(worldViewer, artifact, processed);
                    }
                    handler.relationsModifed(this.relModifiedArts, this.goalMemberReordered, this.sprintMemberReordered);
                    handler.handleColumnEvents(this.artifactEvent, handler.getWorldXViewer());
                }
                catch (Exception ex) {
                    OseeLog.logf(Activator.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Error processing event handler for - %s", (Object[])new Object[]{handler});
                }
            }
        }
    }

    private static final class NotificationHandler
    implements IArtifactEventListener {
        private final Collection<IWorldViewerEventHandler> handlers = new CopyOnWriteArrayList<IWorldViewerEventHandler>();

        public NotificationHandler() {
            OseeEventManager.addListener((IEventListener)this);
        }

        public void add(IWorldViewerEventHandler iWorldEventHandler) {
            this.handlers.add(iWorldEventHandler);
        }

        public void remove(IWorldViewerEventHandler iWorldEventHandler) {
            this.handlers.remove(iWorldEventHandler);
        }

        public void handleArtifactEvent(ArtifactEvent artifactEvent, Sender sender) {
            for (IWorldViewerEventHandler handler : this.handlers) {
                if (!handler.isDisposed()) continue;
                this.handlers.remove(handler);
            }
            try {
                if (artifactEvent.isOnBranch((BranchId)AtsApiService.get().getAtsBranch())) {
                    Runnable runnable = this.createDisplayRunnable(artifactEvent, this.handlers);
                    Displays.ensureInDisplayThread((Runnable)runnable);
                }
            }
            catch (OseeCoreException oseeCoreException) {}
        }

        public List<? extends IEventFilter> getEventFilters() {
            return AtsUtilClient.getAtsObjectEventFilters();
        }

        private Runnable createDisplayRunnable(ArtifactEvent artifactEvent, Collection<IWorldViewerEventHandler> handlers) {
            IAtsTeamWorkflow teamWf;
            Collection modifiedArts = artifactEvent.getCacheArtifacts(new EventModType[]{EventModType.Modified, EventModType.Reloaded});
            Collection relModifiedArts = artifactEvent.getRelCacheArtifacts();
            Collection deletedPurgedArts = artifactEvent.get(new EventModType[]{EventModType.Deleted, EventModType.Purged});
            HashSet<Artifact> allModAndParents = new HashSet<Artifact>(modifiedArts.size() * 2 + relModifiedArts.size());
            for (Artifact art : modifiedArts) {
                allModAndParents.add(art);
                if (!(art instanceof IAtsWorkItem) || (teamWf = ((IAtsWorkItem)art).getParentTeamWorkflow()) == null) continue;
                allModAndParents.add(AtsApiService.get().getQueryServiceIde().getArtifact(teamWf));
            }
            for (Artifact art : relModifiedArts) {
                allModAndParents.add(art);
                if (!(art instanceof IAtsWorkItem) || (teamWf = ((IAtsWorkItem)art).getParentTeamWorkflow()) == null) continue;
                allModAndParents.add(AtsApiService.get().getQueryServiceIde().getArtifact(teamWf));
            }
            Collection goalMemberReordered = artifactEvent.getRelationOrderArtifacts((RelationTypeToken)AtsRelationTypes.Goal_Member, AtsArtifactTypes.Goal);
            Collection sprintMemberReordered = artifactEvent.getRelationOrderArtifacts((RelationTypeToken)AtsRelationTypes.AgileSprintToItem_AtsItem, AtsArtifactTypes.AgileSprint);
            return new DisplayRunnable(modifiedArts, allModAndParents, relModifiedArts, deletedPurgedArts, goalMemberReordered, sprintMemberReordered, artifactEvent, handlers);
        }
    }
}

