/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerSorter;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.column.AtsColumnTokens;
import org.eclipse.osee.ats.ide.column.AssigneeColumnUI;
import org.eclipse.osee.ats.ide.column.EstimatedHoursColumn;
import org.eclipse.osee.ats.ide.column.HoursSpentTotalColumn;
import org.eclipse.osee.ats.ide.column.PercentCompleteTotalColumn;
import org.eclipse.osee.ats.ide.column.RelatedToStateColumn;
import org.eclipse.osee.ats.ide.column.RemainingHoursColumn;
import org.eclipse.osee.ats.ide.column.ResolutionColumn;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsAttributeValueColumn;
import org.eclipse.osee.ats.ide.world.AtsWorldEditorItems;
import org.eclipse.osee.ats.ide.world.IAtsWorldEditorItem;
import org.eclipse.osee.ats.ide.world.WorldXViewerFactory;
import org.eclipse.osee.ats.ide.world.WorldXViewerSorter;
import org.eclipse.osee.ats.ide.world.WorldXViewerUtil;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.IOseeTreeReportProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.SkynetXViewerFactory;

public class TaskXViewerFactory
extends SkynetXViewerFactory {
    public static final String NAMESPACE = "TaskXViewer";
    public static final List<XViewerColumn> TaskViewerVisibleColumns = Arrays.asList(new XViewerColumn[]{new XViewerAtsAttributeValueColumn(AtsColumnTokens.TitleColumn), WorldXViewerFactory.getColumnServiceColumn(AtsColumnTokens.StateColumn), AssigneeColumnUI.getInstance(), PercentCompleteTotalColumn.getInstance(), HoursSpentTotalColumn.getInstance(), ResolutionColumn.getInstance(), EstimatedHoursColumn.getInstance(), RemainingHoursColumn.getInstance(), RelatedToStateColumn.getInstance(), WorldXViewerFactory.getAttributeConfigColumn(AtsColumnTokens.NotesColumn)});
    public static Integer[] widths = new Integer[]{450, 60, 150, 40, 40, 100, 50, 50, 50, 80, 80};

    public TaskXViewerFactory(IOseeTreeReportProvider reportProvider) {
        super(NAMESPACE, reportProvider);
        int widthIndex = 0;
        for (XViewerColumn taskCol : TaskViewerVisibleColumns) {
            XViewerColumn newCol = taskCol.copy();
            newCol.setShow(true);
            newCol.setWidth(widths[widthIndex++].intValue());
            this.registerColumns(new XViewerColumn[]{newCol});
        }
        XViewerColumn[] xViewerColumnArray = WorldXViewerFactory.getWorldViewColumns();
        int newCol = xViewerColumnArray.length;
        int n = 0;
        while (n < newCol) {
            XViewerColumn worldCol = xViewerColumnArray[n];
            if (!TaskViewerVisibleColumns.contains(worldCol)) {
                XViewerColumn newCol2 = worldCol.copy();
                newCol2.setShow(false);
                this.registerColumns(new XViewerColumn[]{newCol2});
            }
            ++n;
        }
        try {
            for (IAtsWorldEditorItem item : AtsWorldEditorItems.getItems()) {
                for (XViewerColumn xCol : item.getXViewerColumns()) {
                    this.registerColumns(new XViewerColumn[]{xCol});
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        WorldXViewerUtil.registerConfigurationsColumns(this);
        this.registerAllAttributeColumns();
    }

    public XViewerSorter createNewXSorter(XViewer xViewer) {
        return new WorldXViewerSorter(xViewer);
    }
}

