/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util;

import java.util.Collection;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.ui.plugin.PluginUiImage;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class CleanupOseeSystemAssignedWorkflows
extends XNavigateItemAction {
    public CleanupOseeSystemAssignedWorkflows() {
        super("Cleanup OSEE System assigned workflows.", (KeyedImage)PluginUiImage.ADMIN, new XNavItemCat[]{AtsNavigateViewItems.ATS_ADMIN, XNavItemCat.OSEE_ADMIN});
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        XResultData results = new XResultData();
        Collection workItems = AtsApiService.get().getQueryService().getWorkItemsFromQuery("select art_id from osee_attribute where attr_type_id in (1152921504606847192) and value like '%99999999%'", new Object[0]);
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("OSEE System Assignee Cleanup");
        for (IAtsWorkItem workItem : workItems) {
            if (!workItem.getAssignees().contains(AtsCoreUsers.SYSTEM_USER)) continue;
            workItem.getStateMgr().removeAssignee(AtsCoreUsers.SYSTEM_USER);
            results.log("Removed System User from " + workItem.toStringWithId());
            changes.add((Object)workItem);
            if (!workItem.getStateMgr().getAssignees().isEmpty()) continue;
            workItem.getStateMgr().addAssignee(AtsCoreUsers.UNASSIGNED_USER);
            results.log("Added UnAssigned to " + workItem.toStringWithId());
        }
        XResultDataUI.report((XResultData)results, (String)this.getName());
        changes.execute();
    }
}

