/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.nebula.widgets.xviewer.IXViewerPreComputedColumn;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnTokens;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.column.AbstractVersionSelector;
import org.eclipse.osee.ats.ide.column.BackgroundLoadingColumn;
import org.eclipse.osee.ats.ide.column.BackgroundLoadingValueProvider;
import org.eclipse.osee.ats.ide.world.WorldXViewer;
import org.eclipse.osee.framework.core.data.RelationTypeSide;

public class TargetedVersionColumnUI
extends AbstractVersionSelector
implements IXViewerPreComputedColumn,
BackgroundLoadingValueProvider {
    public static TargetedVersionColumnUI instance = new TargetedVersionColumnUI();
    public AtomicBoolean loading = new AtomicBoolean(false);
    public AtomicBoolean loaded = new AtomicBoolean(false);
    protected Map<Long, String> idToValueMap = new HashMap<Long, String>();

    public TargetedVersionColumnUI() {
        super(AtsColumnTokens.TargetedVersionColumn);
    }

    public static TargetedVersionColumnUI getInstance() {
        return instance;
    }

    @Override
    public TargetedVersionColumnUI copy() {
        TargetedVersionColumnUI newXCol = new TargetedVersionColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    @Override
    public RelationTypeSide getRelation() {
        return AtsRelationTypes.TeamWorkflowTargetedForVersion_Version;
    }

    @Override
    public Long getKey(Object obj) {
        if (obj instanceof IAtsTeamWorkflow) {
            return ((IAtsTeamWorkflow)obj).getId();
        }
        return null;
    }

    @Override
    public String getValue(IAtsWorkItem teamWf, Map<Long, String> idToValueMap) {
        return super.getColumnText(teamWf, null, 0);
    }

    public void populateCachedValues(Collection<?> objects, Map<Long, String> preComputedValueMap) {
        if (!this.loaded.get() && !this.loading.getAndSet(true)) {
            BackgroundLoadingColumn.startLoadingThread(this.getName(), objects, this.loading, this.loaded, this.idToValueMap, (WorldXViewer)this.getXViewer(), this);
        }
    }

    public String getText(Object obj, Long key, String cachedValue) {
        return BackgroundLoadingColumn.getText(obj, this.loading, this.loaded, this.idToValueMap);
    }
}

