/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.column.AbstractNumericTotalColumn;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;

public class RemainingPointsNumericWorkflowColumn
extends AbstractNumericTotalColumn {
    private static final String CALCULATION_STR = "Points Numeric - (Points Numeric * (Percent Complete from Workflow / 100))";
    private static RemainingPointsNumericWorkflowColumn instance = new RemainingPointsNumericWorkflowColumn();

    public static RemainingPointsNumericWorkflowColumn getInstance() {
        return instance;
    }

    private RemainingPointsNumericWorkflowColumn() {
        super("ats.column.remainingPointsNumericWorkflow", "Remaining Points Numeric - Workflow", "Points Numeric that remain to complete the changes based on percent complete set on workflow.", CALCULATION_STR, (AttributeTypeToken)AtsAttributeTypes.PointsNumeric);
    }

    public RemainingPointsNumericWorkflowColumn copy() {
        RemainingPointsNumericWorkflowColumn newXCol = new RemainingPointsNumericWorkflowColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    @Override
    protected int getPercentComplete(IAtsWorkItem workItem) {
        return (Integer)AtsApiService.get().getQueryServiceIde().getArtifact(workItem).getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.PercentComplete, (Object)0);
    }
}

