/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Map;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.ide.column.BackgroundLoadingColumn;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class ParentAtsIdColumn
extends BackgroundLoadingColumn {
    public static ParentAtsIdColumn instance = new ParentAtsIdColumn();

    public static ParentAtsIdColumn getInstance() {
        return instance;
    }

    private ParentAtsIdColumn() {
        super("ats.column.parentatsid", "Parent ATS ID", 75, XViewerAlign.Left, false, SortDataType.String, false, "ATS ID of Parent Action or Team Workflow");
    }

    public ParentAtsIdColumn copy() {
        ParentAtsIdColumn newXCol = new ParentAtsIdColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    @Override
    public String getValue(IAtsWorkItem workItem, Map<Long, String> idToValueMap) {
        try {
            if (workItem.isTeamWorkflow()) {
                IAtsAction parentAction = workItem.getParentAction();
                return parentAction == null ? "" : parentAction.getAtsId();
            }
            return workItem.getParentTeamWorkflow().getAtsId();
        }
        catch (OseeCoreException ex) {
            return LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
    }
}

