/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.IAltLeftClickProvider;
import org.eclipse.nebula.widgets.xviewer.IMultiColumnEditProvider;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.column.AtsColumnTokens;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.PromptChangeUtil;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumnIdColumn;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class AgileTeamPointsColumnUI
extends XViewerAtsColumnIdColumn
implements IAltLeftClickProvider,
IMultiColumnEditProvider {
    public static AgileTeamPointsColumnUI instance = new AgileTeamPointsColumnUI();

    public static AgileTeamPointsColumnUI getInstance() {
        return instance;
    }

    private AgileTeamPointsColumnUI() {
        super(AtsColumnTokens.AgileTeamPointsColumn);
    }

    @Override
    public XViewerAtsColumnIdColumn copy() {
        AgileTeamPointsColumnUI newXCol = new AgileTeamPointsColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        try {
            IAtsWorkItem workItem;
            boolean modified;
            if (treeItem.getData() instanceof IAtsWorkItem && (modified = this.promptChange(Collections.singleton(workItem = (IAtsWorkItem)treeItem.getData())))) {
                XViewer xViewer = (XViewer)((XViewerColumn)treeColumn.getData()).getXViewer();
                xViewer.update((Object)workItem, null);
                return true;
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return false;
    }

    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        ArrayList<IAtsWorkItem> workItems = new ArrayList<IAtsWorkItem>();
        for (TreeItem treeItem : treeItems) {
            IAtsWorkItem workItem = (IAtsWorkItem)treeItem.getData();
            workItems.add(workItem);
        }
        boolean modified = this.promptChange(workItems);
        if (modified) {
            XViewer xViewer = (XViewer)((XViewerColumn)treeColumn.getData()).getXViewer();
            xViewer.update(workItems.toArray(new Object[workItems.size()]), null);
        }
    }

    private boolean promptChange(Collection<IAtsWorkItem> workItems) {
        boolean modified = false;
        IAtsWorkItem firstWf = workItems.iterator().next();
        IAgileTeam agileTeam = AtsApiService.get().getAgileService().getAgileTeam(firstWf);
        if (agileTeam == null) {
            AWorkbench.popup((String)"Can not determine Agile Team for %s", (String)firstWf.toStringWithId());
            return false;
        }
        AttributeTypeToken attributeType = AtsApiService.get().getAgileService().getAgileTeamPointsAttributeType(agileTeam);
        if (attributeType == null) {
            AWorkbench.popup((String)"Can not determine Agile Team points attribute type for team %s", (String)agileTeam.toStringWithId());
            return false;
        }
        if (AtsAttributeTypes.Points.equals((Object)attributeType)) {
            if (PromptChangeUtil.promptChangeAttributeWI(workItems, (AttributeTypeToken)AtsAttributeTypes.Points, true)) {
                modified = true;
            }
        } else if (AtsAttributeTypes.PointsNumeric.equals((Object)attributeType) && PromptChangeUtil.promptChangeAttributeWI(workItems, (AttributeTypeToken)AtsAttributeTypes.PointsNumeric, true)) {
            modified = true;
        }
        return modified;
    }
}

