/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileItem;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.CountingMap;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.ImageManager;

public class SprintReportAction
extends AbstractAtsAction {
    private final IAgileBacklog bLog;
    private final AtsApi atsApi;
    private final HashCollection<Long, IAgileItem> sprintToItem = new HashCollection();
    private final HashMap<Long, IAgileSprint> idToSprint = new HashMap();
    private XResultData rd;
    private final Map<String, Long> sprintNameToId = new HashMap<String, Long>();

    public SprintReportAction(IAgileBacklog bLog) {
        this.bLog = bLog;
        this.setImageDescriptor(ImageManager.getImageDescriptor((OseeImage)AtsImage.REPORT));
        this.setToolTipText("Generate Sprint Loading Report for Backlog");
        this.atsApi = AtsApiService.get();
    }

    @Override
    public void runWithException() {
        this.sprintToItem.clear();
        this.idToSprint.clear();
        this.sprintNameToId.clear();
        this.rd = new XResultData();
        this.rd.logf("Sprint Loading Report for Backlog %s\n", new Object[]{this.bLog.getName()});
        for (IAgileItem item : this.atsApi.getAgileService().getItems(this.bLog)) {
            IAgileSprint sprint = this.atsApi.getAgileService().getSprint(item);
            if (sprint == null) continue;
            this.sprintToItem.put((Object)sprint.getId(), (Object)item);
            this.idToSprint.put(sprint.getId(), sprint);
            this.sprintNameToId.put(sprint.getName(), sprint.getId());
        }
        this.processSprints();
        XResultDataUI.report((XResultData)this.rd, (String)"Sprint Loading Report");
    }

    private void processSprints() {
        ArrayList<String> sprintNames = new ArrayList<String>();
        sprintNames.addAll(this.sprintNameToId.keySet());
        Collections.sort(sprintNames);
        for (String sprintName : sprintNames) {
            Long sprintId = this.sprintNameToId.get(sprintName);
            IAgileSprint sprint = this.idToSprint.get(sprintId);
            List sprintItems = (List)this.sprintToItem.getValues((Object)sprint.getId());
            this.rd.logf("\n======================================================\nSprint: %s\n======================================================\n", new Object[]{sprint.toString()});
            this.rd.logf("Num Items: %s\n\n", new Object[]{sprintItems.size()});
            Integer sprintPoints = 0;
            CountingMap userNameToPoints = new CountingMap();
            HashSet<String> names = new HashSet<String>();
            for (IAgileItem sprintItem : sprintItems) {
                List assignees;
                String itemPtsStr = this.atsApi.getAgileService().getPointsStr((IAtsWorkItem)sprintItem);
                Integer itemPts = 0;
                if (Strings.isNumeric((String)itemPtsStr)) {
                    itemPts = Integer.valueOf(itemPtsStr);
                    sprintPoints = sprintPoints + itemPts;
                }
                if (itemPts <= 0 || (assignees = sprintItem.getStateMgr().getAssignees()).size() <= 0) continue;
                Integer pointsByAssignee = itemPts / assignees.size();
                for (AtsUser user : assignees) {
                    userNameToPoints.put((Object)user.getName(), pointsByAssignee.intValue());
                    names.add(user.getName());
                }
            }
            this.rd.logf("Num Points: %s\n\n", new Object[]{sprintPoints});
            ArrayList<String> namesSorted = new ArrayList<String>();
            namesSorted.addAll(names);
            Collections.sort(namesSorted);
            for (String name : namesSorted) {
                Integer pts = userNameToPoints.get((Object)name);
                if (pts <= 0) continue;
                this.rd.logf("Pts: %s - %s\n", new Object[]{name, pts});
            }
        }
    }
}

