/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.viewers.actions;

import java.util.logging.Level;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.internal.ServiceUtil;
import org.eclipse.osee.framework.ui.skynet.render.RendererManager;
import org.eclipse.osee.ote.define.artifacts.ArtifactTestRunOperator;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.osee.ote.ui.define.utilities.SelectionHelper;
import org.eclipse.osee.ote.ui.define.viewers.actions.AbstractActionHandler;

public class OpenInArtifactEditor
extends AbstractActionHandler {
    public OpenInArtifactEditor(StructuredViewer viewer, String text) throws Exception {
        super(viewer, text);
    }

    public OpenInArtifactEditor(StructuredViewer viewer, String text, ImageDescriptor image) throws Exception {
        super(viewer, text, image);
    }

    public void run() {
        try {
            ArtifactTestRunOperator operator = SelectionHelper.getInstance().getSelection(this.getViewer());
            if (this.isValidSelection(operator)) {
                Artifact artifact = operator.getTestRunArtifact();
                this.checkPermissions(artifact);
                RendererManager.open((Artifact)artifact, (PresentationType)PresentationType.GENERALIZED_EDIT);
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Unable to open artifact.", (Throwable)ex);
        }
    }

    @Override
    public void updateState() {
        ArtifactTestRunOperator operator = SelectionHelper.getInstance().getSelection(this.getViewer());
        this.setEnabled(this.isValidSelection(operator));
    }

    private boolean isValidSelection(ArtifactTestRunOperator operator) {
        return operator != null && operator.hasValidArtifact() && !operator.isFromLocalWorkspace();
    }

    private void checkPermissions(Artifact artifact) {
        if (ServiceUtil.getOseeClient().getAccessControlService().hasArtifactPermission((ArtifactToken)artifact, PermissionEnum.READ, null).isErrors()) {
            throw new OseeArgumentException("The user %s does not have read access to %s", new Object[]{UserManager.getUser(), artifact});
        }
    }
}

