/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.reports.html;

import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.ote.ui.define.utilities.HtmlStringUtils;

public class HtmlActiveTableColumnData {
    private String name;
    private String type;
    private String dataFormat;
    private boolean sortable;
    private int width;

    public HtmlActiveTableColumnData(String name) {
        this(name, "");
    }

    public HtmlActiveTableColumnData(String name, String type) {
        this.name = name;
        this.type = type;
        this.dataFormat = "";
        this.sortable = true;
        this.width = name.length();
    }

    public String asMetaData() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("name: ");
        builder.append(this.escapeString(this.getName().toLowerCase()));
        if (Strings.isValid((String)this.getType())) {
            builder.append(", type: ");
            builder.append(this.escapeString(this.getType()));
        }
        if (Strings.isValid((String)this.getDataFormat())) {
            builder.append(", dateFormat: ");
            builder.append(this.escapeString(this.getDataFormat()));
        }
        builder.append("}");
        return builder.toString();
    }

    public String asColumnCustomization() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("header: ");
        builder.append("\"");
        builder.append(HtmlStringUtils.escapeString(this.getName()));
        builder.append("\"");
        builder.append(", sortable: ");
        builder.append(this.isSortable());
        builder.append(", dataIndex: ");
        builder.append(this.escapeString(this.getName().toLowerCase()));
        builder.append("}");
        return builder.toString();
    }

    private String escapeString(String value) {
        return HtmlStringUtils.addSingleQuotes(HtmlStringUtils.escapeString(value));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

