/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.reqif.export;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.eclipse.osee.icteam.reqif.export.WordMLContent;

public class WordMLCreator {
    private static String templateStart = "<w:p>";
    private static String templateEnd = "</w:p>";
    private static String template = "<w:r><w:t></w:t></w:r>";
    private static final String START_RUN = "<w:r>";
    private static final String BOLD_RUN = "<w:rPr><w:b/></w:rPr>";
    private static final String ITALIC_RUN = "<w:rPr><w:i/></w:rPr>";
    private static final String BOLD_ITALIC_RUN = "<w:rPr><w:b/><w:i/></w:rPr>";
    private static final String START_TEXT = "<w:t>";

    public StringBuilder createWordML(List<WordMLContent> listWordMlContent) {
        StringBuilder bufferTemp = new StringBuilder();
        try {
            bufferTemp.append(templateStart);
            ByteArrayInputStream in = new ByteArrayInputStream(template.getBytes("UTF-8"));
            for (WordMLContent wordMLContent : listWordMlContent) {
                int c;
                in.reset();
                while ((c = in.read()) != -1) {
                    bufferTemp.append((char)c);
                    if ((char)c != '>') continue;
                    String temp = bufferTemp.toString();
                    if (temp.endsWith(START_RUN)) {
                        if (wordMLContent.isBold() && wordMLContent.isItalic()) {
                            bufferTemp.append(BOLD_ITALIC_RUN);
                        } else if (wordMLContent.isBold()) {
                            bufferTemp.append(BOLD_RUN);
                        } else if (wordMLContent.isItalic()) {
                            bufferTemp.append(ITALIC_RUN);
                        }
                    }
                    if (!temp.endsWith(START_TEXT)) continue;
                    String inputString = wordMLContent.getInputString();
                    if (inputString != null && !inputString.isEmpty() && inputString.contains("&")) {
                        inputString = inputString.replace("&", "&amp;");
                    }
                    bufferTemp.append(inputString);
                }
            }
            bufferTemp.append(templateEnd);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return bufferTemp;
    }
}

