/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal.event;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.core.event.FrameworkEvent;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.event.listener.EventQosType;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;

public class EventListenerRegistry {
    private final Map<EventQosType, EventListeners> qosToListeners = new ConcurrentHashMap<EventQosType, EventListeners>();
    private final Set<IEventListener> listenerSet = new HashSet<IEventListener>();

    public void addListener(EventQosType qos, IEventListener listener) {
        if (listener != null) {
            EventListeners registry = this.qosToListeners.get((Object)qos);
            if (registry == null) {
                registry = new EventListeners();
                this.qosToListeners.put(qos, registry);
            }
            registry.addListener(listener);
            this.listenerSet.add(listener);
        }
    }

    public void removeListener(EventQosType qos, IEventListener listener) {
        if (listener != null) {
            EventListeners registry = this.qosToListeners.get((Object)qos);
            if (registry != null) {
                registry.removeListener(listener);
                if (registry.isEmpty()) {
                    this.qosToListeners.remove((Object)qos);
                }
            }
            this.listenerSet.remove(listener);
        }
    }

    public void removeListener(IEventListener listener) {
        if (listener != null) {
            this.listenerSet.remove(listener);
            EventQosType[] eventQosTypeArray = EventQosType.values();
            int n = eventQosTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                EventQosType type = eventQosTypeArray[n2];
                this.removeListener(type, listener);
                ++n2;
            }
        }
    }

    public int size(EventQosType type) {
        int count = 0;
        EventListeners registry = this.qosToListeners.get((Object)type);
        if (registry != null) {
            count += registry.size();
        }
        return count;
    }

    public int size() {
        return this.listenerSet.size();
    }

    public void clearAll() {
        this.qosToListeners.clear();
        this.listenerSet.clear();
    }

    public <D extends IEventListener> Collection<D> getListeners(EventQosType qos, FrameworkEvent event) {
        Collection<Object> listener = null;
        EventListeners registry = this.qosToListeners.get((Object)qos);
        if (registry != null) {
            listener = registry.getListeners(event.getClass());
        }
        if (listener == null) {
            listener = java.util.Collections.emptyList();
        }
        return listener;
    }

    public String toString() {
        ArrayList<String> values = new ArrayList<String>();
        EventQosType[] eventQosTypeArray = EventQosType.values();
        int n = eventQosTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EventQosType type = eventQosTypeArray[n2];
            EventListeners registry = this.qosToListeners.get((Object)type);
            for (Class<? extends FrameworkEvent> clazz : registry.keySet()) {
                Collection data = registry.getListeners(clazz);
                for (IEventListener listener : data) {
                    values.add(String.format("type[%s] - event[%s] - [%s]", new Object[]{type, clazz, listener}));
                }
            }
            ++n2;
        }
        Object[] listArr = values.toArray(new String[values.size()]);
        Arrays.sort(listArr);
        return Collections.toString((String)"\n", (Object[])listArr);
    }

    private static final class EventListeners {
        private final Map<Class<? extends FrameworkEvent>, Set<IEventListener>> eventClassToListeners = new ConcurrentHashMap<Class<? extends FrameworkEvent>, Set<IEventListener>>();
        private int size = 0;

        private EventListeners() {
        }

        public void addListener(IEventListener listener) {
            if (listener != null) {
                Collection<Class<? extends FrameworkEvent>> events = this.getCompatibleEvents(listener);
                for (Class<? extends FrameworkEvent> clazz : events) {
                    this.add(clazz, listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(Class<? extends FrameworkEvent> clazz, IEventListener listener) {
            Set<IEventListener> items = this.eventClassToListeners.get(clazz);
            if (items == null) {
                items = new HashSet<IEventListener>();
                this.eventClassToListeners.put(clazz, items);
            }
            Set<IEventListener> set = items;
            synchronized (set) {
                if (items.add(listener)) {
                    ++this.size;
                }
            }
        }

        public Set<Class<? extends FrameworkEvent>> keySet() {
            return this.eventClassToListeners.keySet();
        }

        public int size() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.eventClassToListeners.isEmpty();
        }

        public void removeListener(IEventListener listener) {
            if (listener != null) {
                Collection<Class<? extends FrameworkEvent>> events = this.getCompatibleEvents(listener);
                for (Class<? extends FrameworkEvent> clazz : events) {
                    this.remove(clazz, listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(Class<? extends FrameworkEvent> clazz, IEventListener listener) {
            Set<IEventListener> items = this.eventClassToListeners.get(clazz);
            if (items != null) {
                Set<IEventListener> set = items;
                synchronized (set) {
                    if (items.remove(listener)) {
                        --this.size;
                    }
                }
                if (items.isEmpty()) {
                    this.eventClassToListeners.remove(clazz);
                }
            }
        }

        public <D extends IEventListener> Collection<D> getListeners(Class<? extends FrameworkEvent> clazz) {
            Set items = this.eventClassToListeners.get(clazz);
            if (items == null) {
                items = java.util.Collections.emptySet();
            } else {
                HashSet copy = new HashSet();
                copy.addAll(items);
                items = copy;
            }
            return items;
        }

        private Collection<Class<? extends FrameworkEvent>> getCompatibleEvents(IEventListener listener) {
            HashSet<Class<? extends FrameworkEvent>> events = new HashSet<Class<? extends FrameworkEvent>>();
            Method[] methods = listener.getClass().getMethods();
            if (methods != null) {
                Method[] methodArray = methods;
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    Class<?>[] parameters = method.getParameterTypes();
                    if (parameters != null) {
                        Class<?>[] classArray = parameters;
                        int n3 = parameters.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Class<?> parameter = classArray[n4];
                            if (FrameworkEvent.class.isAssignableFrom(parameter)) {
                                events.add(parameter);
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            return events;
        }
    }
}

