/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.access.AccessTopicEventPayload;
import org.eclipse.osee.framework.core.client.AccessTopicEvent;
import org.eclipse.osee.framework.core.client.TopicEventUtil;
import org.eclipse.osee.framework.core.data.ActivityTypeId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.event.AbstractTopicEvent;
import org.eclipse.osee.framework.core.event.EventUtil;
import org.eclipse.osee.framework.core.event.TopicEvent;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.messaging.event.res.RemoteEvent;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.event.EventSystemPreferences;
import org.eclipse.osee.framework.skynet.core.event.OseeEventService;
import org.eclipse.osee.framework.skynet.core.event.filter.BranchIdEventFilter;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.EventQosType;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEvent;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.event.model.EventModType;
import org.eclipse.osee.framework.skynet.core.event.model.RemoteEventServiceEventType;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.skynet.core.event.model.TransactionEvent;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.internal.event.EventListenerRegistry;

public final class OseeEventManager {
    private OseeEventManager() {
    }

    private static OseeEventService getEventService() {
        return ServiceUtil.getEventService();
    }

    private static EventListenerRegistry getEventListeners() {
        return Activator.getEventListeners();
    }

    public static void addPriorityListener(IEventListener listener) {
        OseeEventManager.getEventListeners().addListener(EventQosType.PRIORITY, listener);
    }

    public static void addListener(IEventListener listener) {
        OseeEventManager.getEventListeners().addListener(EventQosType.NORMAL, listener);
    }

    public static void removeAllListeners() {
        OseeEventManager.getEventListeners().clearAll();
    }

    public static void removeListener(IEventListener listener) {
        OseeEventManager.getEventListeners().removeListener(listener);
    }

    public static EventSystemPreferences getPreferences() {
        return Activator.getEventPreferences();
    }

    public static boolean isEventManagerConnected() {
        boolean result = false;
        try {
            OseeEventService eventService = OseeEventManager.getEventService();
            result = eventService.isConnected();
        }
        catch (Exception exception) {}
        return result;
    }

    public static String getConnectionDetails() {
        EventSystemPreferences preferences = OseeEventManager.getPreferences();
        StringBuilder sb = new StringBuilder();
        sb.append("oseeEventBrokerUri [" + preferences.getOseeEventBrokerUri() + "]");
        sb.append("eventDebug [" + preferences.getEventDebug() + "]");
        return sb.toString();
    }

    public static int getNumberOfListeners() {
        return OseeEventManager.getEventListeners().size();
    }

    public static void kickTopicEvent(Object source, TopicEvent topicEvent) {
        Assert.isNotNull((Object)source);
        Assert.isNotNull((Object)topicEvent);
        Assert.isNotNull((Object)topicEvent.getEventType(), (String)"TopicEvent.eventType can not be null");
        Assert.isTrue((boolean)Strings.isValid((String)topicEvent.getTopic()), (String)"TopicEvent.topic can not be null.");
        String sessionJson = TopicEventUtil.getSessionJson();
        topicEvent.addProperty("senderSession", sessionJson);
        OseeEventManager.getEventService().send(source, topicEvent);
    }

    public static void kickAccessTopicEvent(Object source, AccessTopicEventPayload payload, AccessTopicEvent accesstopicEvent) {
        try {
            TopicEvent topicEvent = EventUtil.createTopic((AbstractTopicEvent)accesstopicEvent, (TransactionId)TransactionId.SENTINEL, (Object)payload);
            OseeEventManager.kickTopicEvent(source, topicEvent);
        }
        catch (Exception ex) {
            OseeLog.logf(OseeEventManager.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Error kicking event [%s][%s]", (Object[])new Object[]{accesstopicEvent, payload});
        }
        try {
            if (accesstopicEvent != AccessTopicEvent.USER_AUTHENTICATED) {
                String message = String.format("USER_AUTHENTICATED [%s] Payload [%s]", UserManager.getUser().getUserId(), JsonUtil.toJson((Object)payload));
                ServiceUtil.getOseeClient().getActivityLogEndpoint().createEntry((ActivityTypeId)CoreActivityTypes.ACCESS_CONTROL_MODIFIED, Long.valueOf(0L), ActivityLog.COMPLETE_STATUS, message);
            }
        }
        catch (Exception ex) {
            OseeLog.logf(OseeEventManager.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Error logging activity event [%s][%s]", (Object[])new Object[]{accesstopicEvent, payload});
        }
    }

    public static void kickLocalRemEvent(Object source, RemoteEventServiceEventType remoteEventServiceEventType) {
        OseeEventManager.getEventService().send(source, remoteEventServiceEventType);
    }

    public static void kickBranchEvent(Object source, BranchEvent branchEvent) {
        OseeEventManager.getEventService().send(source, branchEvent);
    }

    public static void kickTransactionEvent(Object source, TransactionEvent transactionEvent) {
        OseeEventManager.getEventService().send(source, transactionEvent);
    }

    public static void kickPersistEvent(Object source, ArtifactEvent artifactEvent) {
        OseeEventManager.getEventService().send(source, artifactEvent);
    }

    public static void kickLocalArtifactReloadEvent(Object source, Collection<? extends ArtifactToken> artifacts) {
        if (OseeEventManager.isDisableEvents()) {
            return;
        }
        ArtifactEvent artifactEvent = new ArtifactEvent((BranchId)artifacts.iterator().next().getBranch(), ArtifactEvent.ArtifactEventType.RELOAD_ARTIFACTS);
        for (ArtifactToken artifactToken : artifacts) {
            artifactEvent.addArtifact(new EventBasicGuidArtifact(EventModType.Reloaded, artifactToken));
        }
        OseeEventManager.getEventService().send(source, artifactEvent);
    }

    public static boolean isDisableEvents() {
        return OseeEventManager.getPreferences().isDisableEvents();
    }

    public static void setDisableEvents(boolean disableEvents) {
        OseeEventManager.getPreferences().setDisableEvents(disableEvents);
    }

    public static String getListenerReport() {
        String toReturn = null;
        toReturn = OseeEventManager.isEventManagerConnected() ? OseeEventManager.getEventListeners().toString() : "Event system is NOT active";
        return toReturn;
    }

    public static List<IEventFilter> getEventFiltersForBranch(BranchId branch) {
        try {
            ArrayList<IEventFilter> eventFilters = new ArrayList<IEventFilter>(2);
            eventFilters.add(new BranchIdEventFilter(branch));
            return eventFilters;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return null;
        }
    }

    public static void internalTestSendRemoteEvent(RemoteEvent remoteEvent) {
        OseeEventManager.getEventService().receive(remoteEvent);
    }

    public static void internalTestProcessBranchEvent(Sender sender, BranchEvent branchEvent) {
        OseeEventManager.getEventService().receive(sender, branchEvent);
    }

    public static void internalTestProcessEventArtifactsAndRelations(Sender sender, ArtifactEvent artifactEvent) {
        OseeEventManager.getEventService().receive(sender, artifactEvent);
    }

    public static void kickCommitEvent(Class<?> class1, ArtifactEvent artifactEvent) {
        OseeEventManager.getEventService().sendCommitEvent(class1, artifactEvent);
    }
}

