/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.conflict;

import java.util.Set;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.ConflictStatus;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.conflict.AttributeConflict;
import org.eclipse.osee.framework.skynet.core.conflict.Conflict;
import org.eclipse.osee.framework.skynet.core.conflict.ConflictBuilder;
import org.eclipse.osee.framework.skynet.core.relation.order.RelationOrderData;
import org.eclipse.osee.framework.skynet.core.relation.order.RelationOrderMergeUtility;
import org.eclipse.osee.framework.skynet.core.relation.order.RelationOrderParser;

public class AttributeConflictBuilder
extends ConflictBuilder {
    private final String sourceValue;
    private final AttributeId attrId;
    private final AttributeTypeGeneric<?> attrTypeId;

    public AttributeConflictBuilder(GammaId sourceGamma, GammaId destGamma, ArtifactId artId, TransactionToken toTransactionId, BranchToken sourceBranch, BranchToken destBranch, String sourceValue, AttributeId attrId, AttributeTypeGeneric<?> attrTypeId) {
        super(sourceGamma, destGamma, artId, toTransactionId, sourceBranch, destBranch);
        this.sourceValue = sourceValue;
        this.attrId = attrId;
        this.attrTypeId = attrTypeId;
    }

    @Override
    public Conflict getConflict(BranchId mergeBranch, Set<ArtifactId> artIdSet) {
        Artifact right;
        Artifact left;
        RelationOrderData mergedOrder;
        for (ArtifactId artifact : artIdSet) {
            if (!this.artId.equals(artifact)) continue;
            return null;
        }
        AttributeConflict attributeConflict = new AttributeConflict(this.sourceGamma, this.destGamma, this.artId, this.toTransactionId, null, this.sourceValue, this.attrId, this.attrTypeId, mergeBranch, this.sourceBranch, this.destBranch);
        if (attributeConflict.getAttributeType().equals((Object)CoreAttributeTypes.WordOleData)) {
            return null;
        }
        if (attributeConflict.getAttributeType().equals((Object)CoreAttributeTypes.RelationOrder) && (mergedOrder = RelationOrderMergeUtility.mergeRelationOrder(left = attributeConflict.getSourceArtifact(), right = attributeConflict.getDestArtifact())) != null) {
            RelationOrderParser parser = new RelationOrderParser();
            String attributeValue = parser.toXml(mergedOrder);
            attributeConflict.setStringAttributeValue(attributeValue);
            attributeConflict.setStatus(ConflictStatus.RESOLVED);
        }
        return attributeConflict;
    }
}

