/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.operations;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.define.ide.traceability.operations.TraceUnitFromResourceOperation;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.operation.AbstractOperation;

public class ImportTraceUnitsOperation
extends AbstractOperation {
    private final BranchId importToBranch;
    private final boolean isRecursive;
    private final boolean isPersistChanges;
    private final boolean fileWithMultiPaths;
    private final boolean addGuidToSourceFile;
    private final Iterable<URI> sources;
    private final String[] traceTypeIds;
    private final boolean includeImpd;

    public ImportTraceUnitsOperation(String jobName, BranchId importToBranch, Iterable<URI> sources, boolean isRecursive, boolean isPersistChanges, boolean fileWithMultiPaths, boolean addGuidToSourceFile, boolean includeImpd, String ... traceHandlerIds) {
        super("ImportTraceUnitsOperation", "org.eclipse.nebula.widgets.xviewer");
        this.importToBranch = importToBranch;
        this.sources = sources;
        this.isRecursive = isRecursive;
        this.isPersistChanges = isPersistChanges;
        this.fileWithMultiPaths = fileWithMultiPaths;
        this.addGuidToSourceFile = addGuidToSourceFile;
        this.includeImpd = includeImpd;
        if (traceHandlerIds == null) {
            this.traceTypeIds = new String[0];
        } else {
            HashSet<String> traceSet = new HashSet<String>(Arrays.asList(traceHandlerIds));
            this.traceTypeIds = traceSet.toArray(new String[traceSet.size()]);
        }
    }

    protected void doWork(IProgressMonitor monitor) {
        if (this.isPersistChanges) {
            TraceUnitFromResourceOperation.importTraceFromTestUnits(monitor, this.sources, this.isRecursive, this.fileWithMultiPaths, this.importToBranch, this.addGuidToSourceFile, this.includeImpd, this.traceTypeIds);
        } else {
            TraceUnitFromResourceOperation.printTraceFromTestUnits(monitor, this.sources, this.isRecursive, this.fileWithMultiPaths, this.addGuidToSourceFile, this.includeImpd, this.traceTypeIds);
        }
    }
}

