/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.define.ide.traceability.TraceabilityProviderOperation;
import org.eclipse.osee.define.ide.traceability.data.RequirementData;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.utility.ViewIdUtility;

public class BranchTraceabilityOperation
extends TraceabilityProviderOperation {
    private final BranchId branch;
    private final RequirementData requirementData;
    private HashCollectionSet<Artifact, String> requirementToTestUnitsMap;
    private Map<String, Artifact> testUnits;
    private final Collection<? extends ArtifactTypeToken> types;
    private final boolean withInheritance;
    private final ArtifactId viewId;

    private BranchTraceabilityOperation(RequirementData requirementData, BranchId branch, Collection<? extends ArtifactTypeToken> types, boolean withInheritance, ArtifactId viewId) {
        super("Branch Traceability Provider", "org.eclipse.osee.define.ide");
        this.requirementData = requirementData;
        this.branch = branch;
        this.types = types;
        this.withInheritance = withInheritance;
        this.viewId = viewId;
    }

    public BranchTraceabilityOperation(BranchToken branch, ArtifactId viewId) {
        this(new RequirementData((BranchId)branch, viewId), (BranchId)branch, Collections.singleton(CoreArtifactTypes.AbstractSoftwareRequirement), true, viewId);
    }

    public BranchTraceabilityOperation(BranchId branch, Collection<? extends ArtifactTypeToken> types, boolean withInheritance, ArtifactId viewId) {
        this(new RequirementData(branch, types, withInheritance, viewId), branch, types, withInheritance, viewId);
    }

    @Override
    public RequirementData getRequirementData() {
        return this.requirementData;
    }

    @Override
    public HashCollectionSet<Artifact, String> getRequirementToCodeUnitsMap() {
        return this.requirementToTestUnitsMap;
    }

    @Override
    public Set<String> getCodeUnits() {
        return this.testUnits.keySet();
    }

    private String convertToJavaFileName(String name) {
        int endOfPackageName = name.lastIndexOf(".");
        if (endOfPackageName != -1) {
            name = String.valueOf(name.substring(endOfPackageName + 1)) + ".java";
        }
        return name;
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        this.requirementData.initialize(monitor);
        this.requirementToTestUnitsMap = new HashCollectionSet(HashSet::new);
        Set excludedArtifactIdMap = ViewIdUtility.findExcludedArtifactsByView((ArtifactId)this.viewId, (BranchId)this.branch);
        List unitsOnBranch = ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)CoreArtifactTypes.TestCase, (BranchId)this.branch);
        if (unitsOnBranch != null) {
            ViewIdUtility.removeExcludedArtifacts(unitsOnBranch.iterator(), (Set)excludedArtifactIdMap);
            this.testUnits = new HashMap<String, Artifact>();
            for (Artifact unit : unitsOnBranch) {
                this.testUnits.put(this.convertToJavaFileName(unit.getName()), unit);
            }
        }
        ArrayList reqs = new ArrayList();
        for (ArtifactTypeToken artifactTypeToken : this.types) {
            if (this.withInheritance) {
                reqs.addAll(ArtifactQuery.getArtifactListFromTypeWithInheritence((ArtifactTypeToken)artifactTypeToken, (BranchId)this.branch, (DeletionFlag)DeletionFlag.EXCLUDE_DELETED));
                continue;
            }
            reqs.addAll(ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)artifactTypeToken, (BranchId)this.branch));
        }
        ViewIdUtility.removeExcludedArtifacts(reqs.iterator(), (Set)excludedArtifactIdMap);
        for (Artifact artifact : reqs) {
            List verifiers = artifact.getRelatedArtifacts(CoreRelationTypes.Verification_Verifier);
            ViewIdUtility.removeExcludedArtifacts(verifiers.iterator(), (Set)excludedArtifactIdMap);
            HashSet<String> verifierNames = new HashSet<String>();
            String inspection = this.getInspectionQual(artifact);
            if (Strings.isValid((String)inspection)) {
                verifierNames.add(inspection);
            }
            for (Artifact verifier : verifiers) {
                verifierNames.add(this.convertToJavaFileName(verifier.getName()));
            }
            this.requirementToTestUnitsMap.put((Object)artifact, verifierNames);
        }
    }

    @Override
    public Collection<Artifact> getTestUnitArtifacts(Artifact requirement) {
        List toReturn = Collections.emptyList();
        if (!requirement.isHistorical()) {
            toReturn = requirement.getRelatedArtifacts(CoreRelationTypes.Verification_Verifier);
        }
        return toReturn;
    }

    @Override
    public Artifact getTestUnitByName(String name) {
        Artifact toReturn = this.testUnits.get(name);
        if (toReturn == null) {
            toReturn = this.testUnits.get(String.valueOf(name) + ".java");
        }
        return toReturn;
    }
}

