/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc;

import java.util.Map;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcLogger;
import org.eclipse.osee.jdbc.JdbcServer;
import org.eclipse.osee.jdbc.JdbcServerConfig;
import org.eclipse.osee.jdbc.internal.JdbcServerFactory;
import org.eclipse.osee.jdbc.internal.JdbcUtil;

public final class JdbcServerBuilder
extends JdbcServerConfig {
    private JdbcLogger logger;
    private boolean loggingEnabled;

    public static JdbcServerBuilder newBuilder() {
        return new JdbcServerBuilder();
    }

    public static JdbcServerBuilder newBuilder(JdbcServerConfig config) {
        return JdbcServerBuilder.newBuilder().withConfig(config);
    }

    public static JdbcServerBuilder newBuilder(Map<String, Object> properties) {
        return JdbcServerBuilder.newBuilder().properties(properties);
    }

    public static JdbcServer fromConfig(JdbcServerConfig config) {
        return JdbcServerBuilder.newBuilder(config).build();
    }

    public static JdbcServerBuilder hsql() {
        return JdbcServerBuilder.hsql(null);
    }

    public static JdbcServerBuilder hsql(String dataPath) {
        JdbcServerBuilder builder = JdbcServerBuilder.newBuilder();
        builder.dbUsername("public");
        builder.dbPassword("");
        builder.dbParam("hsqldb.tx", "MVCC");
        if (Strings.isValid((String)dataPath)) {
            builder.dbPath(dataPath);
        }
        return builder;
    }

    private JdbcServerBuilder() {
    }

    public JdbcServer build() {
        JdbcServerConfig cfg = this.copy();
        if (!Strings.isValid((String)cfg.getDbHost())) {
            if (cfg.acceptRemoteConnections()) {
                cfg.setDbAcceptAddress("0.0.0.0");
            } else {
                cfg.setDbAcceptAddress("127.0.0.1");
            }
        }
        if (cfg.useRandomPort()) {
            int port = JdbcUtil.getRandomPort();
            cfg.setDbListenPort(port);
        }
        if ("org.eclipse.osee.jdbc.internal.dbsupport.hsql.HsqlJdbcServer".equals(cfg.getServerImplClassName()) && !cfg.getProperties().containsKey("hsqldb.tx")) {
            cfg.addDbParam("hsqldb.tx", "MVCC");
        }
        return JdbcServerFactory.newJbdcServer(cfg, this.loggingEnabled, this.logger);
    }

    public JdbcServerBuilder properties(Map<String, Object> src) {
        this.readProperties(src);
        return this;
    }

    public JdbcServerBuilder withConfig(JdbcServerConfig config) {
        this.copy(config);
        return this;
    }

    public JdbcServerBuilder dbListenOn(String value) {
        this.setDbAcceptAddress(value);
        return this;
    }

    public JdbcServerBuilder dbListenPort(int value) {
        this.setDbListenPort(value);
        return this;
    }

    public JdbcServerBuilder dbPath(String value) {
        this.setDbPath(value);
        return this;
    }

    public JdbcServerBuilder dbUsername(String value) {
        this.setDbUsername(value);
        return this;
    }

    public JdbcServerBuilder dbPassword(String value) {
        this.setDbPassword(value);
        return this;
    }

    public JdbcServerBuilder dbParam(String key, String value) {
        this.addDbParam(key, value);
        return this;
    }

    public JdbcServerBuilder startUpWaitTimeMillis(long startUpWaitTimeout) {
        this.setStartUpWaitTimeout(startUpWaitTimeout);
        return this;
    }

    public JdbcServerBuilder aliveWaitTimeMillis(long aliveWaitTimeout) {
        this.setAliveWaitTimeout(aliveWaitTimeout);
        return this;
    }

    public JdbcServerBuilder useRandomPort(boolean useRandomPort) {
        this.setUseRandomPort(useRandomPort);
        return this;
    }

    public JdbcServerBuilder logging(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
        return this;
    }

    public JdbcServerBuilder logger(JdbcLogger logger) {
        this.logger = logger;
        return this;
    }
}

