/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.branch.graph.core;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.IExceptionableRunnable;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.ui.branch.graph.Activator;
import org.eclipse.osee.framework.ui.branch.graph.core.BranchGraphEditorContextMenuProvider;
import org.eclipse.osee.framework.ui.branch.graph.core.BranchGraphEditorInput;
import org.eclipse.osee.framework.ui.branch.graph.core.BranchGraphOutlinePage;
import org.eclipse.osee.framework.ui.branch.graph.core.BranchGraphPaletteProvider;
import org.eclipse.osee.framework.ui.branch.graph.model.GraphCache;
import org.eclipse.osee.framework.ui.branch.graph.operation.LoadGraphOperation;
import org.eclipse.osee.framework.ui.branch.graph.parts.GraphEditPartFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class BranchGraphEditor
extends GraphicalEditorWithFlyoutPalette {
    public static final String EDITOR_ID = "org.eclipse.osee.framework.ui.branch.graph.BranchGraphEditor";
    private BranchGraphOutlinePage overviewOutlinePage;
    private ActionRegistry actionRegistry;
    private BranchGraphPaletteProvider paletteProvider;
    private KeyHandler shareKeyHandler;

    public BranchGraphEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public void setFocus() {
        Control control = this.overviewOutlinePage.getControl();
        if (control != null) {
            control.setFocus();
        }
    }

    public void showGraphFor(BranchGraphEditorInput editorInput) {
        this.setPartName(String.valueOf(editorInput.getName()) + " Graph");
        LoadGraphOperation task = new LoadGraphOperation(this.getSite().getPart(), this.getGraphicalViewer(), this, editorInput.getBranch());
        Jobs.runInJob((String)task.getName(), (IExceptionableRunnable)task, Activator.class, (String)"org.eclipse.osee.framework.ui.branch.graph", (boolean)true);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == GraphicalViewer.class || adapter == EditPartViewer.class) {
            return this.getGraphicalViewer();
        }
        if (adapter == ZoomManager.class) {
            return ((ScalableRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        if (adapter == IContentOutlinePage.class) {
            return this.getOverviewOutlinePage();
        }
        return super.getAdapter(adapter);
    }

    public void refresh() {
        this.getGraphicalViewer().setContents((Object)"Loading graph... This can take several minutes");
        this.showGraphFor((BranchGraphEditorInput)this.getEditorInput());
    }

    public void doSave(IProgressMonitor monitor) {
        OseeLog.log(BranchGraphEditor.class, (Level)Level.WARNING, (String)"method not implemented!");
    }

    public void doSaveAs() {
        OseeLog.log(BranchGraphEditor.class, (Level)Level.WARNING, (String)"method not implemented!");
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public GraphicalViewer getViewer() {
        return this.getGraphicalViewer();
    }

    private BranchGraphOutlinePage getOverviewOutlinePage() {
        RootEditPart rootEditPart;
        if (this.overviewOutlinePage == null && this.getGraphicalViewer() != null && (rootEditPart = this.getGraphicalViewer().getRootEditPart()) instanceof ScalableRootEditPart) {
            this.overviewOutlinePage = new BranchGraphOutlinePage((ScalableRootEditPart)rootEditPart);
        }
        return this.overviewOutlinePage;
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setRootEditPart((RootEditPart)new ScalableRootEditPart());
        viewer.setEditPartFactory((EditPartFactory)new GraphEditPartFactory(viewer));
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        viewer.setContents((Object)"Loading graph... This can take several minutes");
        BranchGraphEditorContextMenuProvider cmProvider = new BranchGraphEditorContextMenuProvider((EditPartViewer)viewer, this);
        viewer.setContextMenu((MenuManager)cmProvider);
        IEditorInput input = this.getEditorInput();
        if (input instanceof BranchGraphEditorInput) {
            BranchGraphEditorInput editorInput = (BranchGraphEditorInput)input;
            this.showGraphFor(editorInput);
        }
        ZoomManager zoomManager = ((ScalableRootEditPart)viewer.getRootEditPart()).getZoomManager();
        ZoomInAction zoomIn = new ZoomInAction(zoomManager);
        ZoomOutAction zoomOut = new ZoomOutAction(zoomManager);
        this.getActionRegistry().registerAction((IAction)zoomIn);
        this.getActionRegistry().registerAction((IAction)zoomOut);
        viewer.setKeyHandler(this.getCommonKeyHandler());
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomIn);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomOut);
        List<String> zoomContributions = Arrays.asList(ZoomManager.FIT_ALL, ZoomManager.FIT_HEIGHT, ZoomManager.FIT_WIDTH);
        zoomManager.setZoomLevelContributions(zoomContributions);
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ContentOutline");
        }
        catch (PartInitException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.shareKeyHandler == null) {
            this.shareKeyHandler = new GraphicalViewerKeyHandler(this.getViewer());
            this.shareKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.shareKeyHandler;
    }

    protected void initializeGraphicalViewer() {
        OseeLog.log(BranchGraphEditor.class, (Level)Level.WARNING, (String)"method not implemented!");
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteProvider == null) {
            this.paletteProvider = new BranchGraphPaletteProvider(this);
        }
        return this.paletteProvider.getPaletteRoot();
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.setCustomizer(new PaletteCustomizer(){

                    public void revertToSaved() {
                    }

                    public void save() {
                    }
                });
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }
        };
    }

    protected GraphicalEditorWithFlyoutPalette.CustomPalettePage createPalettePage() {
        return new GraphicalEditorWithFlyoutPalette.CustomPalettePage(this, this.getPaletteViewerProvider()){

            public void init(IPageSite pageSite) {
                super.init(pageSite);
                IAction copy = BranchGraphEditor.this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId());
                pageSite.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), copy);
            }
        };
    }

    public void setOutlineContent(GraphCache graph) {
        this.getOverviewOutlinePage().setTreeContent(graph);
    }
}

