/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.reqif.export;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.core.model.Branch;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.icteam.reqif.export.RMFUtility;
import org.eclipse.osee.icteam.reqif.export.ReqIFUtil;
import org.eclipse.osee.icteam.reqif.export.UniqueIdentifierGenerator;
import org.eclipse.osee.icteam.reqif.export.WordMLContent;
import org.eclipse.osee.icteam.reqif.export.WordMLCreator;
import org.eclipse.osee.icteam.reqif.util.ModuleUtil;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;
import org.eclipse.rmf.reqif10.DatatypeDefinition;
import org.eclipse.rmf.reqif10.DatatypeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.DatatypeDefinitionString;
import org.eclipse.rmf.reqif10.DatatypeDefinitionXHTML;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIFContent;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecRelation;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.SpecificationType;
import org.eclipse.rmf.reqif10.XhtmlContent;
import org.eclipse.rmf.reqif10.xhtml.XhtmlDivType;
import org.eclipse.rmf.reqif10.xhtml.XhtmlInlPresType;
import org.eclipse.rmf.reqif10.xhtml.XhtmlObjectType;
import org.eclipse.rmf.reqif10.xhtml.XhtmlPType;
import org.xml.sax.SAXException;

public class ReqIfLoad {
    Branch projectBranch = null;
    boolean lineBreak = false;
    StringBuilder stringbuilder = new StringBuilder();
    HashMap<SpecObject, Artifact> requirmentMap = new HashMap();

    public void load(Artifact parentArtifact, String fileName, String moduleName) throws Exception {
        File file = null;
        UniqueIdentifierGenerator.resetNumber();
        file = fileName.endsWith(".xml") ? ReqIFUtil.changeExtension(fileName) : new File(fileName);
        Artifact moduleArtifact = this.createModuleForReqif(parentArtifact, moduleName);
        Object reqIfObj = RMFUtility.LoadReqif(file);
        if (fileName.endsWith(".xml")) {
            file.delete();
        }
        if (reqIfObj instanceof ReqIF) {
            ReqIF reqif = (ReqIF)reqIfObj;
            ReqIFContent coreContent = reqif.getCoreContent();
            EList specifications = coreContent.getSpecifications();
            for (Specification specification : specifications) {
                Iterator reqFolder = this.createReqFolder(specification, moduleArtifact);
                EList children = specification.getChildren();
                this.createSpecObject((EList<SpecHierarchy>)children, (Artifact)reqFolder);
            }
            EList specRelations = coreContent.getSpecRelations();
            for (SpecRelation specRelation : specRelations) {
                this.createRelation(specRelation);
            }
            EList datatypes = coreContent.getDatatypes();
            for (DatatypeDefinition datatypeDefinition : datatypes) {
                this.createDataType(datatypeDefinition, moduleArtifact);
            }
            EList specTypes = coreContent.getSpecTypes();
            for (SpecType specType : specTypes) {
                this.createSpecType(specType, moduleArtifact);
            }
        }
    }

    private void createSpecType(SpecType specType, Artifact moduleArtifact) {
        String identifier = "";
        String longName = "";
        GregorianCalendar lastChange = null;
        if (specType instanceof SpecificationType) {
            lastChange = specType.getLastChange();
            identifier = specType.getIdentifier();
            longName = specType.getLongName();
        }
        SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)this.projectBranch, (String)String.format("Created new %s \"%s\" in artifact explorer", "Requirement", "DataType"));
        Artifact newChild = moduleArtifact.addNewChild(RelationSorter.PREEXISTING, AtsArtifactTypes.SpecificationType, "Specfication Type");
        newChild.addAttribute((AttributeTypeId)AtsAttributeTypes.Identifier, (Object)identifier);
        newChild.addAttribute((AttributeTypeId)AtsAttributeTypes.LongName, (Object)longName);
        if (lastChange != null) {
            newChild.addAttribute((AttributeTypeId)AtsAttributeTypes.LastChange, (Object)lastChange.toString());
        }
        moduleArtifact.persist(transaction);
        transaction.execute();
    }

    private void createDataType(DatatypeDefinition datatypeDefinition, Artifact moduleArtifact) {
        String identifier = "";
        BigInteger maxLength = null;
        GregorianCalendar lastChange = null;
        if (datatypeDefinition instanceof DatatypeDefinitionString) {
            lastChange = datatypeDefinition.getLastChange();
            maxLength = ((DatatypeDefinitionString)datatypeDefinition).getMaxLength();
            identifier = datatypeDefinition.getIdentifier();
            this.createDataTypeDefinitionString(moduleArtifact, lastChange, identifier, maxLength);
        }
        if (datatypeDefinition instanceof DatatypeDefinitionEnumeration) {
            EList specifiedValues = ((DatatypeDefinitionEnumeration)datatypeDefinition).getSpecifiedValues();
            identifier = datatypeDefinition.getIdentifier();
            lastChange = datatypeDefinition.getLastChange();
            SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)this.projectBranch, (String)String.format("Created new %s \"%s\" in artifact explorer", "Requirement", "DataType"));
            Artifact newChild = moduleArtifact.addNewChild(RelationSorter.PREEXISTING, AtsArtifactTypes.DataTypeDefinitionEnum, "DataType");
            Artifact specfiedValues = newChild.addNewChild(RelationSorter.PREEXISTING, AtsArtifactTypes.SpecifiedValues, "Specified Values");
            for (EnumValue enumValue : specifiedValues) {
                identifier = enumValue.getIdentifier();
                Artifact enumValues = specfiedValues.addNewChild(RelationSorter.PREEXISTING, AtsArtifactTypes.EnumValues, "Enums Values");
                enumValues.addAttribute((AttributeTypeId)AtsAttributeTypes.Identifier, (Object)identifier);
            }
            moduleArtifact.persist(transaction);
            transaction.execute();
        }
        if (datatypeDefinition instanceof DatatypeDefinitionXHTML) {
            identifier = datatypeDefinition.getIdentifier();
            lastChange = datatypeDefinition.getLastChange();
            this.createDataTypeDefinitionString(moduleArtifact, lastChange, identifier, maxLength);
        }
    }

    private void createDataTypeDefinitionString(Artifact moduleArtifact, GregorianCalendar lastChange, String identifier, BigInteger maxLength) {
        SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)this.projectBranch, (String)String.format("Created new %s \"%s\" in artifact explorer", "Requirement", "DataType"));
        Artifact newChild = moduleArtifact.addNewChild(RelationSorter.PREEXISTING, AtsArtifactTypes.DataTypeDefinitionString, "DataType");
        newChild.addAttribute((AttributeTypeId)AtsAttributeTypes.Identifier, (Object)identifier);
        if (maxLength != null) {
            newChild.addAttribute((AttributeTypeId)AtsAttributeTypes.MaxLength, (Object)maxLength.toString());
        }
        if (lastChange != null) {
            newChild.addAttribute((AttributeTypeId)AtsAttributeTypes.LastChange, (Object)lastChange.toString());
        }
        moduleArtifact.persist(transaction);
        transaction.execute();
    }

    private void createRelation(SpecRelation specRelation) throws OseeCoreException {
        SpecObject source = specRelation.getSource();
        Artifact srcArtifact = this.requirmentMap.get(source);
        SpecObject target = specRelation.getTarget();
        Artifact destArtifact = this.requirmentMap.get(target);
        srcArtifact.addRelation(CoreRelationTypes.RequirementTrace_HigherLevelRequirement, destArtifact);
        srcArtifact.persist("Relation added");
    }

    private void createSpecObject(EList<SpecHierarchy> children, Artifact reqFolder) throws OseeCoreException, ParserConfigurationException, SAXException, IOException {
        for (SpecHierarchy specHierarchy : children) {
            SpecObject object = specHierarchy.getObject();
            Artifact req = null;
            if (object != null) {
                req = this.createRequirement(object, reqFolder);
            }
            if (specHierarchy.getChildren().size() <= 0) continue;
            this.createSpecObject((EList<SpecHierarchy>)specHierarchy.getChildren(), req);
        }
    }

    private Artifact createRequirement(SpecObject object, Artifact reqFolder) throws OseeCoreException {
        String theValue = "";
        EList values = object.getValues();
        for (AttributeValue attributeValue : values) {
            AttributeValueString value;
            if (attributeValue instanceof AttributeValueString && (theValue = (value = (AttributeValueString)attributeValue).getTheValue()).length() != 0) break;
        }
        if (theValue.length() == 0) {
            theValue = UniqueIdentifierGenerator.createUniqueName("Requirement");
        }
        SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)this.projectBranch, (String)String.format("Created new %s \"%s\" in artifact explorer", "Requirement", theValue));
        Artifact newChild = reqFolder.addNewChild(RelationSorter.PREEXISTING, AtsArtifactTypes.Software_ReQ, theValue);
        for (AttributeValue attributeValue : values) {
            if (!(attributeValue instanceof AttributeValueXHTML)) continue;
            AttributeValueXHTML value = (AttributeValueXHTML)attributeValue;
            XhtmlContent theValue2 = value.getTheValue();
            this.createXhmtlContent(theValue2, newChild);
        }
        reqFolder.persist(transaction);
        transaction.execute();
        this.requirmentMap.put(object, newChild);
        return newChild;
    }

    private void createXhmtlContent(XhtmlContent xhmtContent, Artifact newChild) throws OseeCoreException {
        if (xhmtContent.getXhtml() != null) {
            XhtmlDivType div = (XhtmlDivType)xhmtContent.getXhtml();
            FeatureMap mixed = div.getMixed();
            this.parseXhtmlPtype(mixed);
            this.parseXhtmlObject(mixed);
            List attributes = newChild.getAttributes();
            mixed.get((EStructuralFeature)XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__TEXT, true);
            Attribute wordTemplateContent = null;
            for (Attribute attribute : attributes) {
                if (!attribute.getAttributeType().getName().equals(CoreAttributeTypes.WordTemplateContent)) continue;
                wordTemplateContent = attribute;
            }
            if (wordTemplateContent == null) {
                newChild.addAttribute((AttributeTypeToken)CoreAttributeTypes.WordTemplateContent);
            }
            newChild.setSoleAttributeFromString((AttributeTypeId)CoreAttributeTypes.WordTemplateContent, this.stringbuilder.toString());
            this.stringbuilder.delete(0, this.stringbuilder.length());
        }
    }

    private void parseXhtmlObject(FeatureMap mixed) {
        ArrayList<WordMLContent> listWordMLContent = new ArrayList<WordMLContent>();
        for (FeatureMap.Entry entry : mixed) {
            if (!(entry.getValue() instanceof XhtmlObjectType)) continue;
            XhtmlObjectType div1 = (XhtmlObjectType)entry.getValue();
            FeatureMap mixed2 = div1.getMixed();
            if (mixed2.size() == 0) {
                WordMLContent con = new WordMLContent();
                con.setInputString("");
                con.setBold(false);
                con.setItalic(false);
                listWordMLContent.add(con);
            } else {
                for (FeatureMap.Entry entry2 : mixed2) {
                    WordMLContent content = new WordMLContent();
                    this.parseXhtmlPSubType(entry2, content);
                    listWordMLContent.add(content);
                }
            }
            WordMLCreator wordml = new WordMLCreator();
            StringBuilder wordML = wordml.createWordML(listWordMLContent);
            this.stringbuilder.append((CharSequence)wordML);
            listWordMLContent.clear();
        }
    }

    private void parseXhtmlPtype(FeatureMap mixed) {
        ArrayList<WordMLContent> listWordMLContent = new ArrayList<WordMLContent>();
        for (FeatureMap.Entry entry : mixed) {
            if (!(entry.getValue() instanceof XhtmlPType)) continue;
            XhtmlPType div1 = (XhtmlPType)entry.getValue();
            FeatureMap mixed2 = div1.getMixed();
            if (mixed2.size() == 0) {
                WordMLContent con = new WordMLContent();
                con.setInputString("");
                con.setBold(false);
                con.setItalic(false);
                listWordMLContent.add(con);
            } else {
                for (FeatureMap.Entry entry2 : mixed2) {
                    WordMLContent content = new WordMLContent();
                    this.parseXhtmlPSubType(entry2, content);
                    listWordMLContent.add(content);
                }
            }
            WordMLCreator wordml = new WordMLCreator();
            StringBuilder wordML = wordml.createWordML(listWordMLContent);
            this.stringbuilder.append((CharSequence)wordML);
            listWordMLContent.clear();
        }
    }

    private void parseXhtmlPSubType(Object object, WordMLContent content) {
        if (object instanceof FeatureMap.Entry) {
            FeatureMap.Entry entry = (FeatureMap.Entry)object;
            if (entry.getValue() instanceof XhtmlInlPresType) {
                XhtmlInlPresType i = (XhtmlInlPresType)entry.getValue();
                this.getBoldItalic(i.eContainer(), content);
                FeatureMap mixed = i.getMixed();
                for (FeatureMap.Entry entry2 : mixed) {
                    this.parseXhtmlPSubType(entry2, content);
                }
            } else if (entry.getEStructuralFeature() instanceof EAttribute) {
                content.setInputString((String)entry.getValue());
            }
        }
    }

    private void getBoldItalic(EObject eContainer, WordMLContent content) {
        if (eContainer instanceof XhtmlDivType) {
            EList italicList;
            XhtmlDivType div = (XhtmlDivType)eContainer;
            EList boldList = div.getB();
            if (boldList.size() > 0) {
                content.setBold(true);
            }
            if ((italicList = div.getI()).size() > 0) {
                content.setItalic(true);
            }
        } else if (eContainer instanceof XhtmlInlPresType) {
            EList italicList;
            XhtmlInlPresType type = (XhtmlInlPresType)eContainer;
            EList boldList = type.getB();
            if (boldList.size() > 0) {
                content.setBold(true);
            }
            if ((italicList = type.getI()).size() > 0) {
                content.setItalic(true);
            }
        } else if (eContainer instanceof XhtmlPType) {
            EList italicList;
            XhtmlPType ptype = (XhtmlPType)eContainer;
            EList boldList = ptype.getB();
            if (boldList.size() > 0) {
                content.setBold(true);
            }
            if ((italicList = ptype.getI()).size() > 0) {
                content.setItalic(true);
            }
        }
    }

    private Artifact createModuleForReqif(Artifact parentArtifact, String moduleName) throws OseeCoreException {
        Artifact moduleArtifact = null;
        try {
            this.projectBranch = BranchManager.getBranch((BranchId)parentArtifact.getBranch());
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        List children = parentArtifact.getChildren();
        for (Artifact artifact : children) {
            if (!artifact.getArtifactType().equals(AtsArtifactTypes.RequirementDocument) || !artifact.getName().equals(moduleName)) continue;
            moduleArtifact = artifact;
            break;
        }
        if (moduleArtifact == null) {
            moduleArtifact = ReqIFUtil.createModuleReqFolder(this.projectBranch, parentArtifact, moduleName);
        }
        return moduleArtifact;
    }

    private Artifact createReqFolder(Specification specification, Artifact moduleArtifact) throws OseeCoreException {
        Artifact reqParent = null;
        String longName = specification.getLongName();
        if (longName == null || longName.length() == 0) {
            String uniqueName;
            longName = uniqueName = UniqueIdentifierGenerator.createUniqueNameWithID("Requirement_Folder");
        }
        ModuleUtil.addRequirementChildForModule(moduleArtifact, this.projectBranch, longName, "");
        List children2 = moduleArtifact.getChildren();
        for (Artifact artifact : children2) {
            if (!artifact.getName().equals(longName)) continue;
            reqParent = artifact;
        }
        return reqParent;
    }
}

