/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.reqif.export;

import java.io.File;
import java.io.IOException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.datatypes.DatatypesPackage;
import org.eclipse.rmf.reqif10.serialization.ReqIF10ResourceFactoryImpl;
import org.eclipse.rmf.reqif10.xhtml.XhtmlPackage;

public class RMFUtility {
    public static Object LoadReqif(File file) throws Exception {
        ResourceSetImpl resourceSet = RMFUtility.getResourceSet();
        URI uri = file.isFile() ? URI.createFileURI((String)file.getAbsolutePath()) : URI.createURI((String)file.getName());
        XMLResource resource = (XMLResource)resourceSet.createResource(uri);
        resource.load(null);
        EList rootObjects = resource.getContents();
        if (rootObjects.isEmpty()) {
            return null;
        }
        return rootObjects.get(0);
    }

    protected static void saveReqIFFile(ReqIF reqif, String fileName) throws IOException {
        ResourceSetImpl resourceSet = RMFUtility.getResourceSet();
        File file = new File(fileName);
        file.createNewFile();
        URI uri = file.isFile() ? URI.createFileURI((String)file.getAbsolutePath()) : URI.createURI((String)fileName);
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().add((Object)reqif);
        resource.save(null);
    }

    private static ResourceSetImpl getResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("reqif", new ReqIF10ResourceFactoryImpl());
        return resourceSet;
    }

    public static void setup() throws Exception {
        EPackage.Registry.INSTANCE.clear();
        EPackage.Registry.INSTANCE.put((Object)"http://www.omg.org/spec/ReqIF/20110401/reqif.xsd", (Object)ReqIF10Package.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.w3.org/1999/xhtml", (Object)XhtmlPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.w3.org/1999/xhtml/datatypes/", (Object)DatatypesPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.w3.org/XML/1998/namespace", (Object)XMLNamespacePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2003/XMLType", (Object)XMLTypePackage.eINSTANCE);
    }
}

