/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.JaxRsClientConstants;
import org.eclipse.osee.jaxrs.JaxRsConfirmAccessHandler;
import org.eclipse.osee.jaxrs.JaxRsTokenStore;

public class JaxRsClientConfig {
    private static final Pattern PORT_ADDRESS_PATTERN = Pattern.compile(":(\\d+)");
    private long asyncExecuteTimeout;
    private boolean asyncExecuteTimeoutRejection;
    private long connectionTimeout;
    private long receiveTimeout;
    private JaxRsClientConstants.ConnectionType connectionType;
    private int maxRetransmits;
    private String nonProxyHosts;
    private String fullProxyAddress;
    private String proxyAuthorizationType;
    private String proxyPassword;
    private JaxRsClientConstants.ProxyType proxyType;
    private String proxyUsername;
    private String serverAuthorizationType;
    private String serverPassword;
    private String serverUsername;
    private boolean followRedirects;
    private boolean chunkingAllowed;
    private int chunkingThreshold;
    private int chunkLength;
    private boolean proxyClientSubResourcesInheritHeaders;
    private boolean proxyClientThreadSafe;
    private String oauthAuthorizeUri;
    private String oauthTokenUri;
    private String oauthTokenValidationUri;
    private String oauthClientId;
    private String oauthClientSecret;
    private String oauthRedirectUri;
    private String oauthScopes;
    private JaxRsTokenStore oauthTokenStore;
    private JaxRsConfirmAccessHandler oauthConfirmAccessHandler;
    private String oauthSecretKeyAlgorithm;
    private String oauthEncodedSecretKey;
    private boolean oauthFailsOnRefreshTokenError;
    private boolean oauthCacheEnabled;
    private int oauthCacheMaxSize;
    private long oauthCacheEvictTimeoutMillis;

    public JaxRsClientConfig() {
        this.reset();
    }

    private void reset() {
        this.setAsyncExecuteTimeout(5000L);
        this.setAsyncExecuteTimeoutRejection(true);
        this.setConnectionTimeout(30000L);
        this.setReceiveTimeout(0L);
        this.setConnectionType(JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_CONNECTION_TYPE);
        this.setMaxRetransmits(-1);
        this.setNonProxyHosts(JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_NON_PROXY_HOSTS);
        this.setProxyAddress(JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_PROXY_ADDRESS);
        this.setProxyAuthorizationType("Basic");
        this.setProxyPassword(JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_PROXY_PASSWORD);
        this.setProxyType(JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_PROXY_TYPE);
        this.setProxyUsername(JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_PROXY_USERNAME);
        this.setServerAuthorizationType("Basic");
        this.setServerPassword(JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_SERVER_PASSWORD);
        this.setServerUsername(JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_SERVER_USERNAME);
        this.setFollowRedirects(true);
        this.setChunkingAllowed(true);
        this.setChunkingThreshold(4096);
        this.setChunkLength(0);
        this.setCreateThreadSafeProxyClients(false);
        this.setProxyClientSubResourcesInheritHeaders(false);
        this.setOAuthAuthorizeUri(JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_OAUTH_AUTHORIZE_URI);
        this.setOAuthClientId(JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_OAUTH_CLIENT_ID);
        this.setOAuthClientSecret(JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_OAUTH_CLIENT_SECRET);
        this.setOAuthRedirectUri("urn:ietf:wg:oauth:2.0:oob");
        this.setOAuthTokenUri(JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_OAUTH_TOKEN_URI);
        this.setOAuthTokenValidationUri(JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_OAUTH_TOKEN_VALIDATION_URI);
        this.setOAuthScopes(JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_OAUTH_SCOPES);
        this.setOAuthSecretKeyAlgorithm(JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_OAUTH_SECRET_KEY_ALGORITHM);
        this.setOAuthEncodedSecretKey(JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_OAUTH_ENCODED_SECRET_KEY);
        this.setOAuthFailsOnRefreshTokenError(false);
        this.setOAuthCacheEnabled(true);
        this.setOAuthCacheMaxSize(100);
        this.setOAuthCacheEvictTimeoutMillis(3600000L);
    }

    public boolean isChunkingAllowed() {
        return this.chunkingAllowed;
    }

    public long getAsyncExecuteTimeout() {
        return JaxRsClientConfig.limit(JaxRsClientConstants.TIMEOUT_MIN_LIMIT, this.asyncExecuteTimeout);
    }

    public boolean isAsyncExecuteTimeoutRejection() {
        return this.asyncExecuteTimeoutRejection;
    }

    public long getConnectionTimeout() {
        return JaxRsClientConfig.limit(JaxRsClientConstants.TIMEOUT_MIN_LIMIT, this.connectionTimeout);
    }

    public long getReceiveTimeout() {
        return JaxRsClientConfig.limit(JaxRsClientConstants.TIMEOUT_MIN_LIMIT, this.receiveTimeout);
    }

    public JaxRsClientConstants.ConnectionType getConnectionType() {
        return this.connectionType != null ? this.connectionType : JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_CONNECTION_TYPE;
    }

    public int getMaxRetransmits() {
        return JaxRsClientConfig.limit(JaxRsClientConstants.RETRANSMIT_MIN_LIMIT, this.maxRetransmits);
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public String getProxyAuthorizationType() {
        return this.proxyAuthorizationType;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public JaxRsClientConstants.ProxyType getProxyType() {
        return this.proxyType != null ? this.proxyType : JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_PROXY_TYPE;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getServerAuthorizationType() {
        return this.serverAuthorizationType;
    }

    public String getServerPassword() {
        return this.serverPassword;
    }

    public String getServerUsername() {
        return this.serverUsername;
    }

    public boolean isFollowRedirectsAllowed() {
        return this.followRedirects;
    }

    public int getChunkingThreshold() {
        return JaxRsClientConfig.limit(JaxRsClientConstants.CHUNK_THRESHOLD_MIN_LIMIT, this.chunkingThreshold);
    }

    public int getChunkLength() {
        return JaxRsClientConfig.limit(JaxRsClientConstants.CHUNK_LENGTH_MIN_LIMIT, this.chunkLength);
    }

    public String getProxyAddress() {
        return JaxRsClientConfig.getHost(this.getFullProxyAddress());
    }

    public int getProxyPort() {
        return JaxRsClientConfig.getPort(this.getFullProxyAddress());
    }

    public String getFullProxyAddress() {
        return this.fullProxyAddress;
    }

    public boolean isServerAuthorizationRequired() {
        return Strings.isValid((String)this.getServerUsername()) && Strings.isValid((String)this.getServerPassword());
    }

    public boolean isProxyAuthorizationRequired() {
        return Strings.isValid((String)this.getProxyUsername()) && Strings.isValid((String)this.getProxyPassword());
    }

    public boolean isProxyRequired() {
        return Strings.isValid((String)this.getProxyAddress());
    }

    public boolean isProxyClientSubResourcesInheritHeaders() {
        return this.proxyClientSubResourcesInheritHeaders;
    }

    public boolean isCreateThreadSafeProxyClients() {
        return this.proxyClientThreadSafe;
    }

    public String getOAuthAuthorizeUri() {
        return this.oauthAuthorizeUri;
    }

    public String getOAuthTokenUri() {
        return this.oauthTokenUri;
    }

    public String getOAuthTokenValidationUri() {
        return this.oauthTokenValidationUri;
    }

    public String getOAuthClientId() {
        return this.oauthClientId;
    }

    public String getOAuthClientSecret() {
        return this.oauthClientSecret;
    }

    public String getOAuthRedirectUri() {
        return this.oauthRedirectUri;
    }

    public String getOAuthScopes() {
        return this.oauthScopes;
    }

    public String getOAuthSecretKeyAlgorithm() {
        return this.oauthSecretKeyAlgorithm;
    }

    public String getOAuthEncodedSecretKey() {
        return this.oauthEncodedSecretKey;
    }

    public boolean isOAuthFailsOnRefreshTokenError() {
        return this.oauthFailsOnRefreshTokenError;
    }

    public boolean isOAuthTokenCacheEnabled() {
        return this.oauthCacheEnabled;
    }

    public int getOAuthCacheMaxSize() {
        return this.oauthCacheMaxSize;
    }

    public long getOAuthCacheEvictTimeoutMillis() {
        return this.oauthCacheEvictTimeoutMillis;
    }

    public JaxRsTokenStore getOAuthTokenStore() {
        return this.oauthTokenStore != null ? this.oauthTokenStore : JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_OAUTH_TOKEN_STORE;
    }

    public JaxRsConfirmAccessHandler getOAuthTokenHandler() {
        return this.oauthConfirmAccessHandler != null ? this.oauthConfirmAccessHandler : JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_OAUTH_CONFIRM_ACCESS_HANDLER;
    }

    void setAsyncExecuteTimeout(long asyncExecuteTimeout) {
        this.asyncExecuteTimeout = asyncExecuteTimeout;
    }

    void setAsyncExecuteTimeoutRejection(boolean asyncExecuteTimeoutRejection) {
        this.asyncExecuteTimeoutRejection = asyncExecuteTimeoutRejection;
    }

    void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    void setConnectionType(JaxRsClientConstants.ConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    void setMaxRetransmits(int maxRetransmits) {
        this.maxRetransmits = maxRetransmits;
    }

    void setNonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }

    void setProxyAddress(String fullProxyAddress) {
        this.fullProxyAddress = fullProxyAddress;
    }

    void setProxyAuthorizationType(String proxyAuthorizationType) {
        this.proxyAuthorizationType = proxyAuthorizationType;
    }

    void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    void setProxyType(JaxRsClientConstants.ProxyType proxyType) {
        this.proxyType = proxyType;
    }

    void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    void setServerAuthorizationType(String serverAuthorizationType) {
        this.serverAuthorizationType = serverAuthorizationType;
    }

    void setServerPassword(String serverPassword) {
        this.serverPassword = serverPassword;
    }

    void setServerUsername(String serverUsername) {
        this.serverUsername = serverUsername;
    }

    void setFollowRedirects(boolean autoRedirectsAllowed) {
        this.followRedirects = autoRedirectsAllowed;
    }

    void setChunkingAllowed(boolean chunkingAllowed) {
        this.chunkingAllowed = chunkingAllowed;
    }

    void setChunkingThreshold(int chunkingThreshold) {
        this.chunkingThreshold = chunkingThreshold;
    }

    void setChunkLength(int chunkLength) {
        this.chunkLength = chunkLength;
    }

    void setProxyClientSubResourcesInheritHeaders(boolean proxyClientSubResourcesInheritHeaders) {
        this.proxyClientSubResourcesInheritHeaders = proxyClientSubResourcesInheritHeaders;
    }

    public void setCreateThreadSafeProxyClients(boolean proxyClientThreadSafe) {
        this.proxyClientThreadSafe = proxyClientThreadSafe;
    }

    void setOAuthAuthorizeUri(String oauthAuthorizeUri) {
        this.oauthAuthorizeUri = oauthAuthorizeUri;
    }

    void setOAuthTokenUri(String oauthTokenUri) {
        this.oauthTokenUri = oauthTokenUri;
    }

    void setOAuthTokenValidationUri(String oauthTokenValidationUri) {
        this.oauthTokenValidationUri = oauthTokenValidationUri;
    }

    void setOAuthClientId(String oauthClientId) {
        this.oauthClientId = oauthClientId;
    }

    void setOAuthClientSecret(String oauthClientSecret) {
        this.oauthClientSecret = oauthClientSecret;
    }

    void setOAuthRedirectUri(String oauthRedirectUri) {
        this.oauthRedirectUri = oauthRedirectUri;
    }

    void setOAuthScopes(String oauthScopes) {
        this.oauthScopes = oauthScopes;
    }

    void setOAuthSecretKeyAlgorithm(String oauthSecretKeyAlgorithm) {
        this.oauthSecretKeyAlgorithm = oauthSecretKeyAlgorithm;
    }

    void setOAuthEncodedSecretKey(String oauthEncodedSecretKey) {
        this.oauthEncodedSecretKey = oauthEncodedSecretKey;
    }

    void setOAuthFailsOnRefreshTokenError(boolean oauthFailsOnRefreshTokenError) {
        this.oauthFailsOnRefreshTokenError = oauthFailsOnRefreshTokenError;
    }

    void setOAuthTokenStore(JaxRsTokenStore oauthTokenStore) {
        this.oauthTokenStore = oauthTokenStore;
    }

    void setOAuthConfirmAccessHandler(JaxRsConfirmAccessHandler oauthConfirmAccessHandler) {
        this.oauthConfirmAccessHandler = oauthConfirmAccessHandler;
    }

    void setOAuthCacheEnabled(boolean oauthCacheEnabled) {
        this.oauthCacheEnabled = oauthCacheEnabled;
    }

    void setOAuthCacheMaxSize(int oauthCacheMaxSize) {
        this.oauthCacheMaxSize = oauthCacheMaxSize;
    }

    void setOAuthCacheEvictTimeoutMillis(long oauthCacheEvictTimeoutMillis) {
        this.oauthCacheEvictTimeoutMillis = oauthCacheEvictTimeoutMillis;
    }

    void readProperties(Map<String, Object> src) {
        this.setAsyncExecuteTimeout(JaxRsClientConfig.getLong(src, JaxRsClientConstants.JAXRS_CLIENT_ASYNC_EXECUTE_TIMEOUT, 5000L));
        this.setAsyncExecuteTimeoutRejection(JaxRsClientConfig.getBoolean(src, JaxRsClientConstants.JAXRS_CLIENT_ASYNC_EXECUTE_TIMEOUT_REJECTION, true));
        this.setFollowRedirects(JaxRsClientConfig.getBoolean(src, JaxRsClientConstants.JAXRS_CLIENT_FOLLOW_REDIRECTS, true));
        this.setChunkingAllowed(JaxRsClientConfig.getBoolean(src, JaxRsClientConstants.JAXRS_CLIENT_CHUNKING_ALLOWED, true));
        this.setChunkingThreshold(JaxRsClientConfig.getInt(src, JaxRsClientConstants.JAXRS_CLIENT_CHUNKING_THRESHOLD, 4096));
        this.setChunkLength(JaxRsClientConfig.getInt(src, JaxRsClientConstants.JAXRS_CLIENT_CHUNK_SIZE, 0));
        this.setConnectionTimeout(JaxRsClientConfig.getLong(src, JaxRsClientConstants.JAXRS_CLIENT_CONNECTION_TIMEOUT, 30000L));
        this.setConnectionType(JaxRsClientConfig.getConnectionType(src, JaxRsClientConstants.JAXRS_CLIENT_CONNECTION_TYPE, JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_CONNECTION_TYPE));
        this.setMaxRetransmits(JaxRsClientConfig.getInt(src, JaxRsClientConstants.JAXRS_CLIENT_MAX_RETRANSMITS, -1));
        this.setNonProxyHosts(JaxRsClientConfig.get(src, JaxRsClientConstants.JAXRS_CLIENT_NON_PROXY_HOSTS, JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_NON_PROXY_HOSTS));
        this.setProxyAddress(JaxRsClientConfig.get(src, JaxRsClientConstants.JAXRS_CLIENT_PROXY_ADDRESS, JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_PROXY_ADDRESS));
        this.setProxyAuthorizationType(JaxRsClientConfig.get(src, JaxRsClientConstants.JAXRS_CLIENT_PROXY_AUTHORIZATION_TYPE, "Basic"));
        this.setProxyPassword(JaxRsClientConfig.get(src, JaxRsClientConstants.JAXRS_CLIENT_PROXY_PASSWORD, JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_PROXY_PASSWORD));
        this.setProxyType(JaxRsClientConfig.getProxyType(src, JaxRsClientConstants.JAXRS_CLIENT_PROXY_TYPE, JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_PROXY_TYPE));
        this.setProxyUsername(JaxRsClientConfig.get(src, JaxRsClientConstants.JAXRS_CLIENT_PROXY_USERNAME, JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_PROXY_USERNAME));
        this.setReceiveTimeout(JaxRsClientConfig.getLong(src, JaxRsClientConstants.JAXRS_CLIENT_RECEIVE_TIMEOUT, 0L));
        this.setServerAuthorizationType(JaxRsClientConfig.get(src, JaxRsClientConstants.JAXRS_CLIENT_SERVER_AUTHORIZATION_TYPE, "Basic"));
        this.setServerPassword(JaxRsClientConfig.get(src, JaxRsClientConstants.JAXRS_CLIENT_SERVER_PASSWORD, JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_SERVER_PASSWORD));
        this.setServerUsername(JaxRsClientConfig.get(src, JaxRsClientConstants.JAXRS_CLIENT_SERVER_USERNAME, JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_SERVER_USERNAME));
        this.setCreateThreadSafeProxyClients(JaxRsClientConfig.getBoolean(src, JaxRsClientConstants.JAXRS_CLIENT_CREATE_THREADSAFE_PROXY_CLIENTS, false));
        this.setProxyClientSubResourcesInheritHeaders(JaxRsClientConfig.getBoolean(src, JaxRsClientConstants.JAXRS_CLIENT_PROXY_CLIENT_SUB_RESOURCES_INHERIT_HEADERS, false));
        this.setOAuthAuthorizeUri(JaxRsClientConfig.get(src, JaxRsClientConstants.JAXRS_CLIENT_OAUTH_AUTHORIZE_URI, JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_OAUTH_AUTHORIZE_URI));
        this.setOAuthClientId(JaxRsClientConfig.get(src, JaxRsClientConstants.JAXRS_CLIENT_OAUTH_CLIENT_ID, JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_OAUTH_CLIENT_ID));
        this.setOAuthClientSecret(JaxRsClientConfig.get(src, JaxRsClientConstants.JAXRS_CLIENT_OAUTH_CLIENT_SECRET, JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_OAUTH_CLIENT_SECRET));
        this.setOAuthRedirectUri(JaxRsClientConfig.get(src, JaxRsClientConstants.JAXRS_CLIENT_OAUTH_REDIRECT_URI, "urn:ietf:wg:oauth:2.0:oob"));
        this.setOAuthTokenUri(JaxRsClientConfig.get(src, JaxRsClientConstants.JAXRS_CLIENT_OAUTH_TOKEN_URI, JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_OAUTH_TOKEN_URI));
        this.setOAuthTokenValidationUri(JaxRsClientConfig.get(src, JaxRsClientConstants.JAXRS_CLIENT_OAUTH_TOKEN_VALIDATION_URI, JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_OAUTH_TOKEN_VALIDATION_URI));
        this.setOAuthScopes(JaxRsClientConfig.get(src, JaxRsClientConstants.JAXRS_CLIENT_OAUTH_SCOPES, JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_OAUTH_SCOPES));
        this.setOAuthSecretKeyAlgorithm(JaxRsClientConfig.get(src, JaxRsClientConstants.JAXRS_CLIENT_OAUTH_SECRET_KEY_ALGORITHM, JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_OAUTH_SECRET_KEY_ALGORITHM));
        this.setOAuthEncodedSecretKey(JaxRsClientConfig.get(src, JaxRsClientConstants.JAXRS_CLIENT_OAUTH_ENCODED_SECRET_KEY, JaxRsClientConstants.DEFAULT_JAXRS_CLIENT_OAUTH_ENCODED_SECRET_KEY));
        this.setOAuthFailsOnRefreshTokenError(JaxRsClientConfig.getBoolean(src, JaxRsClientConstants.JAXRS_CLIENT_OAUTH_FAILS_ON_REFRESH_TOKEN_ERROR, false));
        this.setOAuthCacheEnabled(JaxRsClientConfig.getBoolean(src, JaxRsClientConstants.JAXRS_CLIENT_OAUTH_CACHE_ENABLED, true));
        this.setOAuthCacheMaxSize(JaxRsClientConfig.getInt(src, JaxRsClientConstants.JAXRS_CLIENT_OAUTH_CACHE_MAX_SIZE, 100));
        this.setOAuthCacheEvictTimeoutMillis(JaxRsClientConfig.getLong(src, JaxRsClientConstants.JAXRS_CLIENT_OAUTH_CACHE_EVICT_TIMEOUT_MILLIS, 3600000L));
    }

    private void copy(JaxRsClientConfig src, JaxRsClientConfig dest) {
        dest.asyncExecuteTimeout = src.asyncExecuteTimeout;
        dest.asyncExecuteTimeoutRejection = src.asyncExecuteTimeoutRejection;
        dest.connectionTimeout = src.connectionTimeout;
        dest.receiveTimeout = src.receiveTimeout;
        dest.connectionType = src.connectionType;
        dest.maxRetransmits = src.maxRetransmits;
        dest.nonProxyHosts = src.nonProxyHosts;
        dest.fullProxyAddress = src.fullProxyAddress;
        dest.proxyAuthorizationType = src.proxyAuthorizationType;
        dest.proxyPassword = src.proxyPassword;
        dest.proxyType = src.proxyType;
        dest.proxyUsername = src.proxyUsername;
        dest.serverAuthorizationType = src.serverAuthorizationType;
        dest.serverPassword = src.serverPassword;
        dest.serverUsername = src.serverUsername;
        dest.followRedirects = src.followRedirects;
        dest.chunkingAllowed = src.chunkingAllowed;
        dest.chunkingThreshold = src.chunkingThreshold;
        dest.chunkLength = src.chunkLength;
        dest.proxyClientSubResourcesInheritHeaders = src.proxyClientSubResourcesInheritHeaders;
        dest.proxyClientThreadSafe = src.proxyClientThreadSafe;
        dest.oauthAuthorizeUri = src.oauthAuthorizeUri;
        dest.oauthTokenUri = src.oauthTokenUri;
        dest.oauthTokenValidationUri = src.oauthTokenValidationUri;
        dest.oauthClientId = src.oauthClientId;
        dest.oauthClientSecret = src.oauthClientSecret;
        dest.oauthRedirectUri = src.oauthRedirectUri;
        dest.oauthScopes = src.oauthScopes;
        dest.oauthSecretKeyAlgorithm = src.oauthSecretKeyAlgorithm;
        dest.oauthEncodedSecretKey = src.oauthEncodedSecretKey;
        dest.oauthTokenStore = src.oauthTokenStore;
        dest.oauthConfirmAccessHandler = src.oauthConfirmAccessHandler;
        dest.oauthFailsOnRefreshTokenError = src.oauthFailsOnRefreshTokenError;
        dest.oauthCacheEnabled = src.oauthCacheEnabled;
        dest.oauthCacheMaxSize = src.oauthCacheMaxSize;
        dest.oauthCacheEvictTimeoutMillis = src.oauthCacheEvictTimeoutMillis;
    }

    public JaxRsClientConfig copy() {
        JaxRsClientConfig data = new JaxRsClientConfig();
        this.copy(this, data);
        return data;
    }

    protected void copy(JaxRsClientConfig src) {
        this.copy(src, this);
    }

    public String toString() {
        return "JaxRsClientConfig [asyncExecuteTimeout=" + this.asyncExecuteTimeout + ", asyncExecuteTimeoutRejection=" + this.asyncExecuteTimeoutRejection + ", connectionTimeout=" + this.connectionTimeout + ", receiveTimeout=" + this.receiveTimeout + ", connectionType=" + (Object)((Object)this.connectionType) + ", maxRetransmits=" + this.maxRetransmits + ", nonProxyHosts=" + this.nonProxyHosts + ", fullProxyAddress=" + this.fullProxyAddress + ", proxyAuthorizationType=" + this.proxyAuthorizationType + ", proxyPassword=" + this.proxyPassword + ", proxyType=" + (Object)((Object)this.proxyType) + ", proxyUsername=" + this.proxyUsername + ", serverAuthorizationType=" + this.serverAuthorizationType + ", serverPassword=" + this.serverPassword + ", serverUsername=" + this.serverUsername + ", followRedirects=" + this.followRedirects + ", chunkingAllowed=" + this.chunkingAllowed + ", chunkingThreshold=" + this.chunkingThreshold + ", chunkLength=" + this.chunkLength + ", proxyClientSubResourcesInheritHeaders=" + this.proxyClientSubResourcesInheritHeaders + ", proxyClientThreadSafe=" + this.proxyClientThreadSafe + ", oauthAuthorizeUri=" + this.oauthAuthorizeUri + ", oauthTokenUri=" + this.oauthTokenUri + ", oauthTokenValidationUri=" + this.oauthTokenValidationUri + ", oauthClientId=" + this.oauthClientId + ", oauthClientSecret=" + this.oauthClientSecret + ", oauthRedirectUri=" + this.oauthRedirectUri + ", oauthScopes=" + this.oauthScopes + ", oauthTokenStore=" + this.oauthTokenStore + ", oauthConfirmAccessHandler=" + this.oauthConfirmAccessHandler + ", oauthSecretKeyAlgorithm=" + this.oauthSecretKeyAlgorithm + ", oauthEncodedSecretKey=" + this.oauthEncodedSecretKey + ", oauthFailsOnRefreshTokenError=" + this.oauthFailsOnRefreshTokenError + "]";
    }

    private static int limit(int minLimit, int value) {
        return value < minLimit ? minLimit : value;
    }

    private static long limit(long minLimit, long value) {
        return value < minLimit ? minLimit : value;
    }

    private static JaxRsClientConstants.ProxyType getProxyType(Map<String, Object> props, String key, JaxRsClientConstants.ProxyType defaultValue) {
        String toReturn = JaxRsClientConfig.get(props, key, String.valueOf((Object)defaultValue));
        return JaxRsClientConstants.ProxyType.parse(toReturn);
    }

    private static JaxRsClientConstants.ConnectionType getConnectionType(Map<String, Object> props, String key, JaxRsClientConstants.ConnectionType defaultValue) {
        String toReturn = JaxRsClientConfig.get(props, key, String.valueOf((Object)defaultValue));
        return JaxRsClientConstants.ConnectionType.parse(toReturn);
    }

    private static long getLong(Map<String, Object> props, String key, long defaultValue) {
        String toReturn = JaxRsClientConfig.get(props, key, String.valueOf(defaultValue));
        return Strings.isNumeric((String)toReturn) ? Long.parseLong(toReturn) : -1L;
    }

    private static int getInt(Map<String, Object> props, String key, int defaultValue) {
        String toReturn = JaxRsClientConfig.get(props, key, String.valueOf(defaultValue));
        return Strings.isNumeric((String)toReturn) ? Integer.parseInt(toReturn) : -1;
    }

    private static boolean getBoolean(Map<String, Object> props, String key, boolean defaultValue) {
        String toReturn = JaxRsClientConfig.get(props, key, String.valueOf(defaultValue));
        return Boolean.parseBoolean(toReturn);
    }

    private static String get(Map<String, Object> props, String key, String defaultValue) {
        Object object;
        String toReturn = defaultValue;
        Object object2 = object = props != null ? props.get(key) : null;
        if (object != null) {
            toReturn = String.valueOf(object);
        }
        return toReturn;
    }

    private static int getPort(String address) {
        Matcher matcher;
        int toReturn = JaxRsClientConstants.PORT_MIN_LIMIT;
        if (Strings.isValid((String)address) && (matcher = PORT_ADDRESS_PATTERN.matcher(address)).find()) {
            String port = matcher.group(1);
            toReturn = JaxRsClientConfig.limit(JaxRsClientConstants.PORT_MIN_LIMIT, Integer.parseInt(port));
        }
        return toReturn;
    }

    private static String getHost(String address) {
        Matcher matcher;
        String toReturn = address;
        if (Strings.isValid((String)toReturn) && (matcher = PORT_ADDRESS_PATTERN.matcher(toReturn = toReturn.replaceAll(".*?//", ""))).find()) {
            int index = matcher.start(1);
            toReturn = toReturn.substring(0, index - 1);
        }
        return toReturn;
    }
}

