/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.workflow.WorkflowMetrics;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.ats.ide.world.WorldComposite;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.XFormToolkit;
import org.eclipse.osee.framework.ui.swt.FontManager;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;

public class WorkflowMetricsUI {
    protected Label showReleaseMetricsLabel;
    private Action selectionMetricsAction;
    private final WorldComposite worldComposite;
    protected final XFormToolkit toolkit;

    public WorkflowMetricsUI(WorldComposite worldComposite, XFormToolkit toolkit) {
        this.worldComposite = worldComposite;
        this.toolkit = toolkit;
    }

    private void updateExtraInfoLine() {
        if (this.selectionMetricsAction != null && this.selectionMetricsAction.isChecked()) {
            if (this.showReleaseMetricsLabel == null || this.showReleaseMetricsLabel.isDisposed()) {
                this.showReleaseMetricsLabel = this.toolkit.createLabel(this.worldComposite.getParent(), "");
                this.showReleaseMetricsLabel.setLayoutData((Object)new GridData(768));
                this.showReleaseMetricsLabel.setFont(FontManager.getCourierNew12Bold());
            }
            if (this.worldComposite.getXViewer() != null && this.worldComposite.getXViewer().getSelectedWorkflowArtifacts() != null && !this.worldComposite.getXViewer().getSelectedWorkflowArtifacts().isEmpty()) {
                this.showReleaseMetricsLabel.setText(WorkflowMetrics.getEstRemainMetrics(this.worldComposite.getXViewer().getSelectedWorkflowArtifacts(), null, ((TeamWorkFlowArtifact)this.worldComposite.getXViewer().getSelectedWorkflowArtifacts().iterator().next()).getManHrsPerDayPreference(), null));
            } else {
                this.showReleaseMetricsLabel.setText("");
            }
        } else {
            this.showReleaseMetricsLabel.dispose();
        }
        this.worldComposite.getParent().layout();
    }

    public Action getOrCreateAction() {
        if (this.selectionMetricsAction == null) {
            this.selectionMetricsAction = new Action("Show Release Metrics by Selection - Ctrl-X", 2){

                public void run() {
                    try {
                        WorkflowMetricsUI.this.updateExtraInfoLine();
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
            };
            this.selectionMetricsAction.setToolTipText("Show Release Metrics by Selection - Ctrl-X");
            this.selectionMetricsAction.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.PAGE));
            this.addSelectionListener();
        }
        return this.selectionMetricsAction;
    }

    private void addSelectionListener() {
        this.worldComposite.getXViewer().getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WorkflowMetricsUI.this.selectionMetricsAction != null && WorkflowMetricsUI.this.selectionMetricsAction.isChecked()) {
                    WorkflowMetricsUI.this.selectionMetricsAction.run();
                }
            }
        });
    }
}

