/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.action;

import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.ChangeType;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsDatabaseTypeProvider;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.workflow.util.ChangeTypeUtil;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public class ActionArtifactRollup {
    private final IAtsAction action;
    private final AtsApiIde atsApi;
    private static AttributeTypeToken priorityAttrType;

    public ActionArtifactRollup(IAtsAction action) {
        this.action = action;
        if (!action.isTypeEqual((ArtifactTypeId)AtsArtifactTypes.Action)) {
            throw new OseeArgumentException("Artifact must be an Action instead of [%s]", new Object[]{action.getArtifactType()});
        }
        this.atsApi = AtsApiService.get();
    }

    public void resetAttributesOffChildren() {
        ActionArtifactRollup.resetChangeTypeOffChildren(this.action, this.atsApi);
        this.resetPriorityOffChildren();
        this.resetTitleOffChildren();
        this.resetValidationOffChildren();
        this.resetDescriptionOffChildren();
    }

    public static void resetChangeTypeOffChildren(IAtsAction action, AtsApi atsApi) {
        ChangeType changeType = null;
        Collection teamWfs = atsApi.getWorkItemService().getTeams((Object)action);
        if (teamWfs.size() == 1) {
            changeType = ChangeTypeUtil.getChangeType((IAtsWorkItem)((IAtsWorkItem)teamWfs.iterator().next()), (AtsApi)atsApi);
        } else {
            for (IAtsTeamWorkflow team : teamWfs) {
                if (team.isCancelled()) continue;
                if (changeType == null) {
                    changeType = ChangeTypeUtil.getChangeType((IAtsWorkItem)team, (AtsApi)atsApi);
                    continue;
                }
                if (changeType == ChangeTypeUtil.getChangeType((IAtsWorkItem)team, (AtsApi)atsApi)) continue;
                return;
            }
        }
        if (changeType != null && ChangeTypeUtil.getChangeType((IAtsAction)action, (AtsApi)atsApi) != changeType) {
            if (changeType == ChangeType.None) {
                ((Artifact)action.getStoreObject()).deleteAttributes((AttributeTypeId)AtsAttributeTypes.ChangeType);
            } else {
                ((Artifact)action.getStoreObject()).setSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.ChangeType, (Object)changeType.name());
            }
        }
    }

    private void resetTitleOffChildren() {
        String title = null;
        for (IAtsTeamWorkflow team : this.atsApi.getWorkItemServiceIde().getTeams(this.action)) {
            if (Strings.isInValid((String)title)) {
                title = team.getName();
                continue;
            }
            if (title.equals(team.getName())) continue;
            return;
        }
        if (!title.equals(this.action.getName())) {
            ((Artifact)this.action.getStoreObject()).setName(title);
        }
    }

    private void resetValidationOffChildren() {
        boolean validationRequired = false;
        for (IAtsTeamWorkflow team : this.atsApi.getWorkItemServiceIde().getTeams(this.action)) {
            if (!((Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)team, (AttributeTypeToken)AtsAttributeTypes.ValidationRequired, (Object)false)).booleanValue()) continue;
            validationRequired = true;
        }
        if (validationRequired != (Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)this.action, (AttributeTypeToken)AtsAttributeTypes.ValidationRequired, (Object)false)) {
            this.atsApi.getAttributeResolver().setSoleAttributeValue((IAtsObject)this.action, (AttributeTypeId)AtsAttributeTypes.ValidationRequired, (Object)false);
        }
    }

    private void resetDescriptionOffChildren() {
        String desc = "";
        for (IAtsTeamWorkflow team : this.atsApi.getWorkItemServiceIde().getTeams(this.action)) {
            if (desc.isEmpty()) {
                desc = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)team, (AttributeTypeToken)AtsAttributeTypes.Description, (Object)"");
                continue;
            }
            if (desc.equals(this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)team, (AttributeTypeToken)AtsAttributeTypes.Description, (Object)""))) continue;
            return;
        }
        if (!desc.equals(this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)this.action, (AttributeTypeToken)AtsAttributeTypes.Description, (Object)""))) {
            this.atsApi.getAttributeResolver().setSoleAttributeValue((IAtsObject)this.action, (AttributeTypeId)AtsAttributeTypes.Description, (Object)desc);
        }
        if (desc.isEmpty()) {
            ((Artifact)this.action).deleteSoleAttribute((AttributeTypeId)AtsAttributeTypes.Description);
        }
    }

    private AttributeTypeToken getPrioirtyAttrType() {
        if (priorityAttrType == null) {
            for (IAtsDatabaseTypeProvider provider : this.atsApi.getDatabaseTypeProviders()) {
                if (!provider.useFactory()) continue;
                priorityAttrType = provider.getPrioirtyAttrType();
                return priorityAttrType;
            }
            priorityAttrType = AtsAttributeTypes.Priority;
        }
        return priorityAttrType;
    }

    private void resetPriorityOffChildren() {
        AttributeTypeToken attrType = this.getPrioirtyAttrType();
        String priorityType = null;
        Collection teamArts = this.atsApi.getWorkItemService().getTeams((Object)this.action);
        if (teamArts.size() == 1) {
            priorityType = this.atsApi.getAttributeResolver().getSoleAttributeValueAsString((IAtsObject)teamArts.iterator().next(), attrType, "");
        } else {
            for (IAtsTeamWorkflow team : teamArts) {
                if (team.isCancelled()) continue;
                if (priorityType == null) {
                    priorityType = this.atsApi.getAttributeResolver().getSoleAttributeValueAsString((IAtsObject)team, attrType, "");
                    continue;
                }
                if (priorityType.equals(this.atsApi.getAttributeResolver().getSoleAttributeValueAsString((IAtsObject)team, attrType, ""))) continue;
                return;
            }
        }
        if (Strings.isValid(priorityType) && this.atsApi.getStoreService().isAttributeTypeValid((IAtsObject)this.action, attrType)) {
            this.atsApi.getAttributeResolver().setSoleAttributeValue((IAtsObject)this.action, (AttributeTypeId)attrType, (Object)priorityType);
        }
    }
}

