/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search.internal.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.api.query.IAtsConfigCacheQuery;
import org.eclipse.osee.ats.api.query.IAtsConfigQuery;
import org.eclipse.osee.ats.api.query.IAtsQuery;
import org.eclipse.osee.ats.api.query.IAtsWorkItemFilter;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.core.query.AbstractAtsQueryService;
import org.eclipse.osee.ats.core.query.AtsConfigCacheQueryImpl;
import org.eclipse.osee.ats.core.query.AtsWorkItemFilter;
import org.eclipse.osee.ats.ide.search.internal.query.AtsConfigQueryImpl;
import org.eclipse.osee.ats.ide.search.internal.query.AtsQueryImpl;
import org.eclipse.osee.framework.core.JaxRsApi;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class AtsQueryServiceImpl
extends AbstractAtsQueryService {
    private static final Pattern namespacePattern = Pattern.compile("\"namespace\"\\s*:\\s*\"(.*?)\"");
    private final AtsApi atsApi;
    private final JaxRsApi jaxRsApi;

    public AtsQueryServiceImpl(AtsApi atsApi, JdbcService jdbcService) {
        super(jdbcService, atsApi);
        this.atsApi = atsApi;
        this.jaxRsApi = atsApi.jaxRsApi();
    }

    public IAtsQuery createQuery(WorkItemType workItemType, WorkItemType ... workItemTypes) {
        Conditions.checkNotNull((Object)workItemType, (String)"workItemType");
        AtsQueryImpl query = new AtsQueryImpl(this.atsApi);
        query.isOfType(new WorkItemType[]{workItemType});
        if (workItemTypes != null) {
            WorkItemType[] workItemTypeArray = workItemTypes;
            int n = workItemTypes.length;
            int n2 = 0;
            while (n2 < n) {
                WorkItemType type = workItemTypeArray[n2];
                query.isOfType(new WorkItemType[]{type});
                ++n2;
            }
        }
        return query;
    }

    public IAtsConfigQuery createQuery(ArtifactTypeToken ... artifactType) {
        AtsConfigQueryImpl query = new AtsConfigQueryImpl(this.atsApi);
        query.isOfType(artifactType);
        return query;
    }

    public IAtsWorkItemFilter createFilter(Collection<? extends IAtsWorkItem> workItems) {
        return new AtsWorkItemFilter(workItems, this.atsApi);
    }

    public TransactionId saveSearch(AtsSearchData data) {
        User userArt = UserManager.getUser();
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Save ATS Search", this.atsApi.getUserService().getCurrentUser());
        TransactionId transaction = TransactionId.SENTINEL;
        try {
            IAttribute<Object> attr = this.getAttrById((ArtifactId)userArt, data.getId());
            if (attr == null) {
                changes.addAttribute((ArtifactId)userArt, (AttributeTypeToken)CoreAttributeTypes.AtsActionSearch, (Object)this.jaxRsApi.toJson((Object)data));
            } else {
                changes.setAttribute((ArtifactId)userArt, attr, (Object)this.jaxRsApi.toJson((Object)data));
            }
            if (!changes.isEmpty()) {
                transaction = changes.execute();
            }
            this.atsApi.getUserService().getCurrentUserNoCache();
        }
        catch (Exception ex) {
            throw new OseeCoreException("Unable to store ATS Search", (Throwable)ex);
        }
        return transaction;
    }

    private IAttribute<Object> getAttrById(ArtifactId artifact, Long attrId) {
        for (IAttribute attr : this.atsApi.getAttributeResolver().getAttributes(artifact, (AttributeTypeToken)CoreAttributeTypes.AtsActionSearch)) {
            String jsonValue = (String)attr.getValue();
            try {
                AtsSearchData data = this.fromJson(jsonValue);
                if (!attrId.equals(data.getId())) continue;
                return attr;
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public TransactionId removeSearch(AtsSearchData data) {
        User user = UserManager.getUser();
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Remove ATS Search", this.atsApi.getUserService().getCurrentUser());
        TransactionId transaction = TransactionId.SENTINEL;
        try {
            IAttribute<Object> attr = this.getAttrById((ArtifactId)user, data.getId());
            if (attr != null) {
                changes.deleteAttribute((ArtifactId)user, attr);
                transaction = changes.execute();
            }
            this.atsApi.getUserService().getCurrentUserNoCache();
        }
        catch (Exception ex) {
            throw new OseeCoreException("Unable to remove ATS Search", (Throwable)ex);
        }
        return transaction;
    }

    public AtsSearchData getSearch(AtsUser atsUser, Long id) {
        try {
            AtsSearchData existing;
            ArtifactId userArt = this.atsApi.getStoreObject((IAtsObject)atsUser);
            IAttribute<Object> attr = this.getAttrById(userArt, id);
            if (attr != null && (existing = this.fromJson((String)attr.getValue())) != null) {
                return existing;
            }
            return null;
        }
        catch (Exception ex) {
            throw new OseeCoreException("Unable to get ATS Search", (Throwable)ex);
        }
    }

    private AtsSearchData fromJson(String jsonValue) {
        Matcher m = namespacePattern.matcher(jsonValue);
        if (m.find()) {
            String namespace = m.group(1);
            return this.atsApi.getSearchDataProvider(namespace).fromJson(namespace, jsonValue);
        }
        return null;
    }

    public AtsSearchData getSearch(String jsonStr) {
        return this.fromJson(jsonStr);
    }

    public Collection<ArtifactToken> getArtifacts(Collection<ArtifactId> ids, BranchId branch) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)ArtifactQuery.getArtifactListFrom(ids, (BranchId)branch));
    }

    public Collection<ArtifactToken> getArtifacts(BranchId branch, boolean includeInherited, ArtifactTypeToken ... artifactType) {
        List<ArtifactTypeToken> types = Arrays.asList(artifactType);
        if (includeInherited) {
            if (artifactType.length == 1) {
                return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)ArtifactQuery.getArtifactListFromTypeWithInheritence((ArtifactTypeToken)types.iterator().next(), (BranchId)branch, (DeletionFlag)DeletionFlag.EXCLUDE_DELETED));
            }
            throw new UnsupportedOperationException("Not supported on client");
        }
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)ArtifactQuery.getArtifactListFromTypes(types, (BranchId)branch, (DeletionFlag)DeletionFlag.EXCLUDE_DELETED));
    }

    public ArtifactToken getArtifactToken(ArtifactId artifactId) {
        return ArtifactQuery.getArtifactTokenFromId((BranchId)this.atsApi.getAtsBranch(), (ArtifactId)artifactId);
    }

    public Collection<ArtifactToken> getRelatedToTokens(BranchToken branch, ArtifactId artifact, RelationTypeSide relationType, ArtifactTypeId artifactType) {
        HashCollection tokenMap = ArtifactQuery.getArtifactTokenListFromRelated((BranchToken)this.atsApi.getAtsBranch(), Collections.singleton(artifact), (ArtifactTypeId)artifactType, (RelationTypeSide)relationType);
        Collection result = tokenMap.getValues((Object)artifact);
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    public Artifact getArtifact(Long id) {
        Conditions.assertTrue((id > 0L ? 1 : 0) != 0, (String)"Art Id must be > 0, not %s", (Object[])new Object[]{id});
        return ArtifactQuery.checkArtifactFromId((ArtifactId)ArtifactId.valueOf((Long)id), (BranchId)this.atsApi.getAtsBranch());
    }

    public <T extends IAtsObject> Artifact getArtifact(T atsObject) {
        Artifact result = null;
        try {
            if (atsObject.getStoreObject() instanceof Artifact) {
                result = (Artifact)atsObject.getStoreObject();
            } else {
                result = this.getArtifact(atsObject.getId());
                if (result != null) {
                    atsObject.setStoreObject((ArtifactToken)result);
                }
            }
        }
        catch (ArtifactDoesNotExist artifactDoesNotExist) {}
        return result;
    }

    public <T extends ArtifactId> Artifact getArtifact(T artifact) {
        IAtsObject atsObject;
        Artifact result = artifact instanceof Artifact ? ArtifactQuery.getArtifactOrNull((ArtifactId)((Artifact)artifact), (DeletionFlag)DeletionFlag.EXCLUDE_DELETED) : (artifact instanceof IAtsObject ? ((atsObject = (IAtsObject)artifact).getStoreObject() instanceof Artifact ? ArtifactQuery.getArtifactFromToken((ArtifactId)((Artifact)atsObject.getStoreObject())) : this.getArtifact(atsObject.getId())) : this.getArtifact(artifact.getId()));
        return result;
    }

    public Artifact getArtifact(ArtifactId artifact, BranchId branch) {
        return this.getArtifact(artifact, branch, DeletionFlag.EXCLUDE_DELETED);
    }

    public Artifact getArtifact(ArtifactId artifact, BranchId branch, DeletionFlag deletionFlag) {
        return ArtifactQuery.getArtifactOrNull((ArtifactId)artifact, (BranchId)branch, (DeletionFlag)deletionFlag);
    }

    public Collection<ArtifactToken> getArtifacts(Collection<Long> ids) {
        ArrayList<ArtifactId> artifactIds = new ArrayList<ArtifactId>(ids.size());
        for (Long id : ids) {
            artifactIds.add(ArtifactId.valueOf((Long)id));
        }
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)ArtifactQuery.getArtifactListFrom(artifactIds, (BranchId)this.atsApi.getAtsBranch(), (DeletionFlag)DeletionFlag.EXCLUDE_DELETED));
    }

    public ArtifactToken getArtifactByName(ArtifactTypeToken artType, String name) {
        return ArtifactQuery.checkArtifactFromTypeAndName((ArtifactTypeId)artType, (String)name, (BranchId)this.atsApi.getAtsBranch());
    }

    public Collection<ArtifactToken> getArtifacts(AttributeTypeToken attrType, String value, BranchToken branch) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)ArtifactQuery.getArtifactListFromAttribute((AttributeTypeId)attrType, (String)value, (BranchId)branch));
    }

    public ArtifactToken getArtifactByNameOrSentinel(ArtifactTypeToken artType, String name) {
        if (ArtifactQuery.checkArtifactFromTypeAndName((ArtifactTypeId)artType, (String)name, (BranchId)this.atsApi.getAtsBranch()) != null) {
            return ArtifactQuery.checkArtifactFromTypeAndName((ArtifactTypeId)artType, (String)name, (BranchId)this.atsApi.getAtsBranch());
        }
        return ArtifactReadable.SENTINEL;
    }

    public ArtifactToken getHistoricalArtifactOrNull(ArtifactId artifact, TransactionToken transaction, DeletionFlag deletionFlag) {
        return ArtifactQuery.getHistoricalArtifactOrNull((ArtifactId)artifact, (TransactionToken)transaction, (DeletionFlag)deletionFlag);
    }

    public ArtifactToken getArtifactByGuid(String guid) {
        return ArtifactQuery.getArtifactFromId((String)guid, (BranchId)this.atsApi.getAtsBranch());
    }

    public ArtifactToken getArtifactByGuidOrSentinel(String guid) {
        if (ArtifactQuery.getArtifactFromId((String)guid, (BranchId)this.atsApi.getAtsBranch()) != null) {
            return ArtifactQuery.getArtifactFromId((String)guid, (BranchId)this.atsApi.getAtsBranch());
        }
        return ArtifactReadable.SENTINEL;
    }

    public List<ArtifactToken> getArtifactListFromTypeWithInheritence(ArtifactTypeToken artifactType, BranchId branch, DeletionFlag deletionFlag) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)ArtifactQuery.getArtifactListFromTypeWithInheritence((ArtifactTypeToken)artifactType, (BranchId)branch, (DeletionFlag)deletionFlag));
    }

    public IAtsConfigCacheQuery createConfigCacheQuery(ArtifactTypeToken ... artifactType) {
        AtsConfigCacheQueryImpl query = new AtsConfigCacheQueryImpl(this.atsApi);
        query.isOfType(artifactType);
        return query;
    }

    public List<ArtifactToken> getArtifactListFromTypeAndAttribute(ArtifactTypeId artifactType, AttributeTypeId attributeType, String attributeValue, BranchId branch) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)ArtifactQuery.getArtifactListFromTypeAndAttribute((ArtifactTypeId)artifactType, (AttributeTypeId)attributeType, (String)attributeValue, (BranchId)branch));
    }

    public List<ArtifactToken> getArtifactListFromAttributeValues(AttributeTypeId attributeType, Collection<ArtifactToken> ids, BranchId branch) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)ArtifactQuery.getArtifactListFromAttributeValues((AttributeTypeId)attributeType, (Collection)org.eclipse.osee.framework.jdk.core.util.Collections.castAll(ids), (BranchId)branch));
    }

    public List<ArtifactToken> getArtifactListFromAttributeValues(AttributeTypeId attributeType, Collection<String> attributeValues, BranchId branch, int artifactCountEstimate) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)ArtifactQuery.getArtifactListFromAttributeValues((AttributeTypeId)attributeType, attributeValues, (BranchId)branch, (int)artifactCountEstimate));
    }

    public List<ArtifactToken> getArtifactListFromTypeAndAttribute(ArtifactTypeToken artifactType, AttributeTypeId attributeType, Set<ArtifactToken> ids, BranchId branch) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)ArtifactQuery.getArtifactListFromTypeAndAttribute((ArtifactTypeId)artifactType, (AttributeTypeId)attributeType, (Collection)org.eclipse.osee.framework.jdk.core.util.Collections.castAll(ids), (BranchId)branch));
    }

    public Collection<? extends ArtifactToken> getArtifactListFromAttributeKeywords(BranchId branch, String userId, boolean isMatchWordOrder, DeletionFlag deletionFlag, boolean caseSensitive, AttributeTypeString ... attrType) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)ArtifactQuery.getArtifactListFromAttributeKeywords((BranchId)branch, (String)userId, (boolean)isMatchWordOrder, (DeletionFlag)deletionFlag, (boolean)caseSensitive, (AttributeTypeId[])attrType));
    }

    public Collection<ArtifactToken> getArtifactsById(Collection<ArtifactId> artifactIds, BranchToken branch, DeletionFlag deletionFlag) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)ArtifactQuery.getArtifactListFrom(artifactIds, (BranchId)branch, (DeletionFlag)deletionFlag));
    }

    public ArtifactToken getArtifactFromAttribute(AttributeTypeToken attrType, String value, BranchId branch) {
        return ArtifactQuery.getArtifactFromAttribute((AttributeTypeId)attrType, (String)value, (BranchId)branch);
    }

    public List<ArtifactToken> getArtifactListFromAttributeValues(AttributeTypeToken attributeType, Collection<String> values, int estimatedCount) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)ArtifactQuery.getArtifactListFromAttributeValues((AttributeTypeId)attributeType, values, (BranchId)this.atsApi.getAtsBranch(), (int)estimatedCount));
    }

    public ArtifactToken getArtifactFromTypeAndAttribute(ArtifactTypeToken artifactType, AttributeTypeToken attributeType, String value, BranchId branch) {
        return ArtifactQuery.getArtifactFromTypeAndAttribute((ArtifactTypeId)artifactType, (AttributeTypeId)attributeType, (String)value, (BranchId)branch);
    }
}

