/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.core.util.RecentlyVisistedItem;
import org.eclipse.osee.ats.core.util.RecentlyVisitedItems;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.RecentlyVisitedNavigateItem;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorSimpleProvider;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;

public class RecentlyVisitedNavigateItems
extends XNavigateItemAction
implements IWorkbenchListener {
    private static final String NAME = "Recently Visited Workflows";
    private static RecentlyVisitedItems visitedItems;
    private static String RECENTLY_VISITED_TOKENS;
    private static RecentlyVisitedNavigateItems topNavigateItem;

    static {
        RECENTLY_VISITED_TOKENS = "recentlyVisitedTokens";
    }

    public RecentlyVisitedNavigateItems(XNavItemCat category) {
        super(NAME, (OseeImage)AtsImage.GLOBE, new XNavItemCat[]{category});
        topNavigateItem = this;
        PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)this);
        this.refresh();
    }

    public void refresh() {
        if (topNavigateItem != null) {
            Thread refresh = new Thread(((Object)((Object)topNavigateItem)).getClass().getSimpleName()){

                @Override
                public void run() {
                    super.run();
                    RecentlyVisitedNavigateItems.ensureFirstLoad();
                    topNavigateItem.getChildren().clear();
                    for (RecentlyVisistedItem item : visitedItems.getReverseVisited()) {
                        RecentlyVisitedNavigateItem navigateItem = new RecentlyVisitedNavigateItem(item);
                        topNavigateItem.addChild((XNavigateItem)navigateItem);
                    }
                    if (RecentlyVisitedNavigateItems.this.refresher != null) {
                        Displays.ensureInDisplayThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                RecentlyVisitedNavigateItems.this.refresher.refresh((XNavigateItem)topNavigateItem);
                            }
                        });
                    }
                }
            };
            refresh.start();
        }
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        RecentlyVisitedNavigateItems.ensureFirstLoad();
        ArrayList<ArtifactToken> workItems = new ArrayList<ArtifactToken>();
        for (RecentlyVisistedItem item : visitedItems.getReverseVisited()) {
            IAtsWorkItem workItem = AtsApiService.get().getWorkItemService().getWorkItem(item.getIdToken());
            if (workItem == null || AtsApiService.get().getStoreService().isDeleted((ArtifactId)item.getIdToken())) continue;
            workItems.add(workItem.getStoreObject());
        }
        WorldEditor.open(new WorldEditorSimpleProvider(this.getName(), workItems, null, tableLoadOptions));
    }

    public static void clearVisited() {
        RecentlyVisitedNavigateItems.ensureFirstLoad();
        visitedItems.clearVisited();
        topNavigateItem.refresh();
    }

    public static void addVisited(IAtsWorkItem workItem) {
        RecentlyVisitedNavigateItems.ensureFirstLoad();
        visitedItems.addVisited(workItem);
        if (topNavigateItem != null) {
            topNavigateItem.refresh();
        }
    }

    private static void ensureFirstLoad() {
        if (visitedItems == null) {
            try {
                AtsApiIde atsApi = AtsApiService.get();
                String recentlyVisistedTokensJson = atsApi.getUserConfigValue(RECENTLY_VISITED_TOKENS);
                visitedItems = Strings.isValid((String)recentlyVisistedTokensJson) ? (RecentlyVisitedItems)atsApi.jaxRsApi().readValue(recentlyVisistedTokensJson, RecentlyVisitedItems.class) : new RecentlyVisitedItems();
            }
            catch (Exception ex) {
                AtsApiService.get().getLogger().error("Unable to read visited items from Ats Config attribute on user artifact %s; Exception %s", new Object[]{AtsApiService.get().getUserService().getCurrentUser(), Lib.exceptionToString((Exception)ex)});
                visitedItems = new RecentlyVisitedItems();
            }
        }
    }

    public static List<RecentlyVisistedItem> getReverseItems() {
        RecentlyVisitedNavigateItems.ensureFirstLoad();
        return visitedItems.getReverseVisited();
    }

    public void postShutdown(IWorkbench workbench) {
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        try {
            String fromStoreJson;
            String toStoreJson;
            if (visitedItems != null && !visitedItems.getReverseVisited().isEmpty() && !(toStoreJson = AtsApiService.get().jaxRsApi().toJson((Object)visitedItems)).equals(fromStoreJson = AtsApiService.get().getUserConfigValue(RECENTLY_VISITED_TOKENS))) {
                AtsApiService.get().setUserConfigValue(RECENTLY_VISITED_TOKENS, toStoreJson);
            }
        }
        catch (Exception ex) {
            OseeLog.log(RecentlyVisitedNavigateItem.class, (Level)Level.WARNING, (String)"Error saving recently visited items.", (Throwable)ex);
        }
        return true;
    }
}

