/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.bit;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactData;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactDatas;
import org.eclipse.osee.ats.ide.editor.tab.bit.XBitViewer;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.widgets.Widget;

public class XBitContentProvider
implements ITreeContentProvider {
    private final XBitViewer bitViewer;

    public XBitContentProvider(XBitViewer bitViewer) {
        this.bitViewer = bitViewer;
    }

    public String toString() {
        return "XBitContentProvider";
    }

    public void clear(boolean forcePend) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Widgets.isAccessible((Widget)XBitContentProvider.this.bitViewer.getControl())) {
                    XBitContentProvider.this.bitViewer.setInput(java.util.Collections.emptyList());
                    XBitContentProvider.this.bitViewer.refresh();
                }
            }
        }, (boolean)forcePend);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof BuildImpactDatas) {
            BuildImpactDatas bids = (BuildImpactDatas)parentElement;
            return bids.getBuildImpacts().toArray();
        }
        if (parentElement instanceof BuildImpactData) {
            BuildImpactData bid = (BuildImpactData)parentElement;
            return bid.getTeamWfs().toArray();
        }
        return Collections.EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof ArtifactToken) {
            return this.bitViewer.getBids().getTeamWfToBidMap().get(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof String) {
            return new Object[]{inputElement};
        }
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

