/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.event;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.IBranchEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEvent;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEventType;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.ui.swt.Displays;

public class WfeBranchEventManager
implements IBranchEventListener {
    List<WorkflowEditor> editors = new CopyOnWriteArrayList<WorkflowEditor>();
    static WfeBranchEventManager instance = new WfeBranchEventManager();

    private WfeBranchEventManager() {
        OseeEventManager.addListener((IEventListener)this);
    }

    public static void add(WorkflowEditor editor) {
        OseeEventManager.addListener((IEventListener)instance);
        if (instance != null && !WfeBranchEventManager.instance.editors.contains(editor)) {
            WfeBranchEventManager.instance.editors.add(editor);
        }
    }

    public static void remove(WorkflowEditor editor) {
        if (instance != null) {
            WfeBranchEventManager.instance.editors.remove(editor);
        }
    }

    public List<? extends IEventFilter> getEventFilters() {
        return null;
    }

    public void handleBranchEvent(Sender sender, BranchEvent branchEvent) {
        for (WorkflowEditor editor : new ArrayList<WorkflowEditor>(this.editors)) {
            if (!editor.isDisposed()) continue;
            this.editors.remove(editor);
        }
        for (WorkflowEditor handler : this.editors) {
            try {
                this.safelyProcessHandler(branchEvent.getEventType(), branchEvent.getSourceBranch());
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)("Error processing event handler - " + handler), (Throwable)ex);
            }
        }
    }

    private void safelyProcessHandler(BranchEventType branchEventType, BranchId branch) {
        block5: for (final WorkflowEditor editor : this.editors) {
            if (editor.isDisposed()) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Unexpected handler disposed but not unregistered.");
            }
            AbstractWorkflowArtifact awa = editor.getWorkItem();
            try {
                if (!awa.isTeamWorkflow()) {
                    return;
                }
                switch (branchEventType) {
                    case Added: 
                    case Purging: 
                    case Purged: 
                    case Deleting: 
                    case Deleted: 
                    case Committing: 
                    case Committed: {
                        if (!(awa instanceof TeamWorkFlowArtifact)) continue block5;
                        TeamWorkFlowArtifact teamArt = (TeamWorkFlowArtifact)awa;
                        BranchToken assocBranch = AtsApiService.get().getBranchService().getWorkingBranch((IAtsTeamWorkflow)teamArt);
                        if (!branch.equals(assocBranch)) continue block5;
                        Displays.ensureInDisplayThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (editor.isDisposed()) {
                                    return;
                                }
                                try {
                                    editor.refresh();
                                    editor.onDirtied();
                                }
                                catch (Exception ex) {
                                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                                }
                            }
                        });
                    }
                }
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
    }
}

