/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.ui.skynet.FrameworkArtifactImageProvider;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;
import org.eclipse.swt.graphics.Image;

public class ActionableItemOwner
extends XViewerAtsColumn
implements IXViewerValueColumn {
    public static ActionableItemOwner instance = new ActionableItemOwner();

    public static ActionableItemOwner getInstance() {
        return instance;
    }

    protected ActionableItemOwner() {
        super("ats.column.aiOwner", "Actionable Item Owner", 80, XViewerAlign.Left, false, SortDataType.String, false, null);
    }

    public ActionableItemOwner copy() {
        ActionableItemOwner newXCol = new ActionableItemOwner();
        super.copy(this, newXCol);
        return newXCol;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            return Collections.toString((String)"; ", ActionableItemOwner.getActionableItemOwners(element));
        }
        catch (OseeCoreException ex) {
            return LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
    }

    public static Set<User> getActionableItemOwners(Object element) {
        HashSet<User> users = new HashSet<User>();
        if (element instanceof IAtsAction) {
            for (IAtsTeamWorkflow teamArt : AtsApiService.get().getWorkItemServiceIde().getTeams(element)) {
                users.addAll(ActionableItemOwner.getActionableItemOwners(teamArt));
            }
        } else if (element instanceof AbstractWorkflowArtifact) {
            TeamWorkFlowArtifact teamArt = (TeamWorkFlowArtifact)((AbstractWorkflowArtifact)((Object)element)).getParentTeamWorkflow();
            if (teamArt != null) {
                for (IAtsActionableItem aia : AtsApiService.get().getActionableItemService().getActionableItems((IAtsWorkItem)teamArt)) {
                    for (ArtifactToken art : AtsApiService.get().getRelationResolver().getRelated((ArtifactId)aia.getStoreObject(), AtsRelationTypes.ActionableItem_User)) {
                        users.add((User)art);
                    }
                }
            }
        } else if (element instanceof IAtsWorkItem) {
            return ActionableItemOwner.getActionableItemOwners(((IAtsWorkItem)element).getStoreObject());
        }
        return users;
    }

    @Override
    public Image getColumnImage(Object element, XViewerColumn xCol, int columnIndex) {
        try {
            return FrameworkArtifactImageProvider.getUserImage(ActionableItemOwner.getActionableItemOwners(element));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getDescription() {
        return "Owners (if any) of Actionable Items associated with Team Workflows.";
    }
}

