/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.ai;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.JaxAtsConfigObject;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;

public class ActionableItem
extends JaxAtsConfigObject
implements IAtsActionableItem {
    @JsonSerialize(using=ToStringSerializer.class)
    Long parentId;
    @JsonSerialize(using=ToStringSerializer.class)
    Long teamDefId;
    Set<Long> children = new HashSet<Long>();
    boolean actionable = false;
    boolean allowUserActionCreation = true;

    public ActionableItem() {
    }

    public ActionableItem(ArtifactToken artifact, AtsApi atsApi) {
        super(artifact.getId(), artifact.getName());
        this.setStoreObject(artifact);
        this.setAtsApi(atsApi);
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getTeamDefId() {
        return this.teamDefId;
    }

    public void setTeamDefId(Long teamDefId) {
        this.teamDefId = teamDefId;
    }

    public Set<Long> getChildren() {
        return this.children;
    }

    public void setChildren(Collection<Long> children) {
        this.children.addAll(children);
    }

    public void addChild(ActionableItem child) {
        this.children.add(child.getId());
    }

    public ArtifactTypeToken getArtifactType() {
        return AtsArtifactTypes.ActionableItem;
    }

    @Override
    @JsonIgnore
    public IAtsActionableItem getParentActionableItem() {
        Long parentId = this.getParentId();
        if (parentId != null) {
            return this.atsApi.getConfigService().getConfigurations().getIdToAi().get(parentId);
        }
        return null;
    }

    @Override
    @JsonIgnore
    public Collection<IAtsActionableItem> getChildrenActionableItems() {
        ArrayList<IAtsActionableItem> aias = new ArrayList<IAtsActionableItem>();
        for (Long childId : this.getChildren()) {
            aias.add(this.atsApi.getConfigService().getConfigurations().getIdToAi().get(childId));
        }
        return aias;
    }

    @Override
    @JsonIgnore
    public IAtsTeamDefinition getTeamDefinition() {
        Long teamDefId = this.getTeamDefId();
        if (teamDefId != null) {
            return this.atsApi.getConfigService().getConfigurations().getIdToTeamDef().get(teamDefId);
        }
        return null;
    }

    @Override
    public boolean isActionable() {
        return this.actionable;
    }

    public void setActionable(boolean actionable) {
        this.actionable = actionable;
    }

    @Override
    public boolean isAllowUserActionCreation() {
        return this.allowUserActionCreation;
    }

    public void setAllowUserActionCreation(boolean allowUserActionCreation) {
        this.allowUserActionCreation = allowUserActionCreation;
    }

    public boolean isInActive() {
        return !this.active;
    }
}

