/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.utility;

import java.util.Collection;
import java.util.Random;
import org.eclipse.osee.framework.core.enums.JoinItem;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.OseePreparedStatement;

public abstract class AbstractJoinQuery
implements AutoCloseable {
    private static final Long DEFAULT_JOIN_EXPIRATION_SECONDS = 10800L;
    private static final String INSERT_INTO_JOIN_CLEANUP = "INSERT INTO osee_join_cleanup (query_id, table_name, issued_at, expires_in) VALUES (?,?,?,?)";
    private static final String DELETE_FROM_JOIN_CLEANUP = "DELETE FROM osee_join_cleanup WHERE query_id =?";
    private static final Random random = new Random();
    private final JoinItem joinItem;
    private final Long queryId;
    protected final OseePreparedStatement addressing;
    private final JdbcClient jdbcClient;
    private final JdbcConnection connection;
    private boolean wasStored;

    protected AbstractJoinQuery(JoinItem joinItem, JdbcClient jdbcClient, JdbcConnection connection) {
        this.joinItem = joinItem;
        this.queryId = random.nextLong();
        this.addressing = jdbcClient.getBatchStatement(connection, joinItem.getInsertSql());
        this.jdbcClient = jdbcClient;
        this.connection = connection;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.addressing.size();
    }

    public Long getQueryId() {
        return (long)this.queryId;
    }

    public void store() {
        if (this.wasStored) {
            throw new OseeCoreException("Cannot store query id twice", new Object[0]);
        }
        this.jdbcClient.runPreparedUpdate(this.connection, INSERT_INTO_JOIN_CLEANUP, new Object[]{this.queryId, this.joinItem.getJoinTableName(), this.getIssuedAt(), DEFAULT_JOIN_EXPIRATION_SECONDS});
        this.addressing.execute();
        this.wasStored = true;
    }

    private Long getIssuedAt() {
        return System.currentTimeMillis() / 1000L;
    }

    @Override
    public void close() {
        if (this.wasStored) {
            this.jdbcClient.runPreparedUpdate(this.connection, this.joinItem.getDeleteSql(), new Object[]{this.queryId});
            this.jdbcClient.runPreparedUpdate(this.connection, DELETE_FROM_JOIN_CLEANUP, new Object[]{this.queryId});
        } else {
            this.addressing.close();
        }
    }

    public String toString() {
        return String.format("id: [%s] entrySize: [%d]", this.getQueryId(), this.size());
    }

    protected void addToBatch(Object obj1) {
        this.addressing.addToBatch((Object)this.queryId, obj1);
    }

    protected void addToBatch(Object obj1, Object obj2, Object obj3, Object obj4) {
        this.addressing.addToBatch((Object)this.queryId, obj1, obj2, obj3, obj4);
    }

    public void addAndStore(Collection<? extends Id> ids) {
        for (Id id : ids) {
            this.addressing.addToBatch((Object)this.queryId, (Object)id);
        }
        this.store();
    }
}

