/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.revision;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.KindType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.exception.OseeTypeDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.attribute.AttributeTypeManager;
import org.eclipse.osee.framework.skynet.core.change.ArtifactChange;
import org.eclipse.osee.framework.skynet.core.change.AttributeChange;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.skynet.core.change.RelationChange;

public class ChangeData {
    private static final String IMPL_DETAILS = " (Impl Details)";
    private static final String DELETED = " (Deleted)";
    private final Collection<Change> changes;

    public ChangeData(Collection<Change> changes) {
        this.changes = changes;
    }

    public boolean isEmpty() {
        return this.getChanges() == null || this.getChanges().isEmpty();
    }

    public Collection<Change> getChanges() {
        return this.changes;
    }

    public Collection<Change> getArtifactChangesById(ArtifactId art) {
        HashSet<Change> foundChanges = new HashSet<Change>();
        try {
            for (Change change : this.changes) {
                if (!(change instanceof ArtifactChange) || !change.getChangeArtifact().equals(art)) continue;
                foundChanges.add(change);
            }
            return foundChanges;
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public Collection<Change> getArtifactChangesByName(String name, String appendedInfo) {
        HashSet<Change> foundChanges = new HashSet<Change>();
        try {
            for (Change change : this.changes) {
                if (!(change instanceof ArtifactChange)) continue;
                if (this.isDeleted(change) && this.isAppendedDeleted(appendedInfo)) {
                    if (!change.getArtifactName().equals(name)) continue;
                    foundChanges.add(change);
                    continue;
                }
                if (this.isImplDetails(change) && this.isAppendedImplDetails(appendedInfo)) {
                    if (!change.getArtifactName().equals(name)) continue;
                    foundChanges.add(change);
                    continue;
                }
                if (!Strings.isInValid((String)appendedInfo) || this.isDeleted(change) || this.isImplDetails(change) || !change.getArtifactName().equals(name)) continue;
                foundChanges.add(change);
            }
            return foundChanges;
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private boolean isImplDetails(Change change) {
        return change.getArtifactType().inheritsFrom((ArtifactTypeId)CoreArtifactTypes.AbstractImplementationDetails);
    }

    private boolean isDeleted(Change change) {
        return change.getModificationType().equals(ModificationType.DELETED);
    }

    private boolean isAppendedImplDetails(String otherDetails) {
        return Strings.isValid((String)otherDetails) && otherDetails.equals(IMPL_DETAILS);
    }

    private boolean isAppendedDeleted(String otherDetails) {
        return Strings.isValid((String)otherDetails) && otherDetails.equals(DELETED);
    }

    public Collection<Artifact> getArtifacts(KindType kindType, ModificationType ... modificationType) {
        return this.getArtifacts(kindType, (Collection<AttributeTypeId>)null, modificationType);
    }

    public Collection<Artifact> getArtifacts(KindType kindType, Collection<AttributeTypeId> artifactTypesToIgnore, ModificationType ... modificationType) {
        if (kindType == KindType.RelationOnly) {
            return this.getArtifactsRelationOnly(modificationType);
        }
        List<ModificationType> modTypes = Arrays.asList(modificationType);
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        if (!(kindType != KindType.Artifact && kindType != KindType.ArtifactOrRelation && kindType != KindType.Relation || this.isEmpty())) {
            HashMap<Artifact, Boolean> excludeArtifacts = new HashMap<Artifact, Boolean>();
            for (Change change : this.changes) {
                Artifact artifact = change.getChangeArtifact();
                ModificationType modType = change.getModificationType();
                if (artifactTypesToIgnore != null && !artifactTypesToIgnore.isEmpty()) {
                    try {
                        if (change instanceof AttributeChange) {
                            long typeId = change.getItemTypeId().getId();
                            AttributeTypeGeneric<?> attributeType = AttributeTypeManager.getAttributeType(typeId);
                            if (excludeArtifacts.containsKey((Object)artifact)) {
                                if (!artifactTypesToIgnore.contains(attributeType) && ((Boolean)excludeArtifacts.get((Object)artifact)).booleanValue()) {
                                    excludeArtifacts.put(artifact, false);
                                }
                            } else {
                                excludeArtifacts.put(artifact, artifactTypesToIgnore.contains(attributeType));
                            }
                        }
                    }
                    catch (OseeTypeDoesNotExist oseeTypeDoesNotExist) {}
                }
                if (!modTypes.isEmpty() && !modTypes.contains(modType)) continue;
                if ((kindType == KindType.Artifact || kindType == KindType.ArtifactOrRelation) && this.isAttributeChangeMergeType(change)) {
                    artifacts.add(artifact);
                    continue;
                }
                if ((kindType == KindType.Artifact || kindType == KindType.ArtifactOrRelation) && change instanceof ArtifactChange) {
                    artifacts.add(artifact);
                    continue;
                }
                if (kindType != KindType.Relation && kindType != KindType.ArtifactOrRelation || !(change instanceof RelationChange)) continue;
                artifacts.add(artifact);
                RelationChange relChange = (RelationChange)change;
                artifacts.add(relChange.getEndTxBArtifact());
            }
            if (artifactTypesToIgnore != null && !artifactTypesToIgnore.isEmpty()) {
                HashSet<Artifact> excludeList = new HashSet<Artifact>();
                for (Artifact artifactToCheck : artifacts) {
                    Boolean remove = (Boolean)excludeArtifacts.get((Object)artifactToCheck);
                    if (remove == null || !remove.booleanValue()) continue;
                    excludeList.add(artifactToCheck);
                }
                artifacts.removeAll(excludeList);
            }
        }
        return artifacts;
    }

    private boolean isAttributeChangeMergeType(Change change) {
        return change instanceof AttributeChange && change.getModificationType() == ModificationType.MERGED;
    }

    private Collection<Artifact> getArtifactsRelationOnly(ModificationType ... modificationType) {
        Collection<Artifact> artMod = this.getArtifacts(KindType.Artifact, modificationType);
        Collection<Artifact> relMod = this.getArtifacts(KindType.Relation, modificationType);
        return Collections.setComplement(relMod, artMod);
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            KindType[] kindTypeArray = KindType.values();
            int n = kindTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                KindType kindType = kindTypeArray[n2];
                Collection<Artifact> artifacts = this.getArtifacts(kindType, new ModificationType[0]);
                sb.append(String.format("Kind: %s Num: %s\n", kindType, artifacts.size()));
                ++n2;
            }
            return sb.toString();
        }
        catch (OseeCoreException ex) {
            return ex.toString();
        }
    }
}

