/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.relation;

import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.model.event.DefaultBasicGuidArtifact;
import org.eclipse.osee.framework.core.model.event.DefaultBasicIdRelation;
import org.eclipse.osee.framework.core.sql.OseeSql;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidRelation;
import org.eclipse.osee.framework.skynet.core.relation.RelationEventType;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.skynet.core.transaction.BaseTransactionData;

public class RelationTransactionData
extends BaseTransactionData {
    private static final String INSERT_INTO_RELATION_TABLE = "INSERT INTO osee_relation_link (rel_link_id, rel_link_type_id, a_art_id, b_art_id, rationale, gamma_id) VALUES (?,?,?,?,?,?)";
    private final RelationLink relation;
    private final RelationEventType relationEventType;

    public RelationTransactionData(RelationLink relation, ModificationType modificationType, RelationEventType relationEventType) {
        super(Id.valueOf((Long)relation.getId()), modificationType);
        this.relation = relation;
        this.relationEventType = relationEventType;
    }

    @Override
    public OseeSql getSelectTxNotCurrentSql() {
        if (this.relation.getRelationType().isNewRelationTable()) {
            return OseeSql.TX_GET_PREVIOUS_TX_NOT_CURRENT_RELATIONS2;
        }
        return OseeSql.TX_GET_PREVIOUS_TX_NOT_CURRENT_RELATIONS;
    }

    @Override
    protected void addInsertToBatch(BaseTransactionData.InsertDataCollector collector) {
        super.addInsertToBatch(collector);
        if (!this.relation.isUseBackingData()) {
            this.internalAddInsertToBatch(collector, 4, INSERT_INTO_RELATION_TABLE, this.relation.getId(), this.relation.getRelationType(), this.relation.getArtifactIdA(), this.relation.getArtifactIdB(), this.relation.getRationale(), this.getGammaId());
        }
    }

    @Override
    protected void internalUpdate(TransactionRecord transactionId) {
        this.relation.internalSetGammaId(this.getGammaId());
    }

    @Override
    protected void internalClearDirtyState() {
        this.relation.setNotDirty();
    }

    @Override
    protected void internalOnRollBack() {
    }

    @Override
    protected GammaId createGammaId() {
        GammaId newGammaId = this.relation.isUseBackingData() ? this.relation.getGammaId() : this.getNextGammaIdFromSequence();
        return newGammaId;
    }

    @Override
    protected void internalAddToEvents(ArtifactEvent artifactEvent) {
        Artifact artifactA = this.relation.getArtifactA();
        Artifact artifactB = this.relation.getArtifactB();
        DefaultBasicGuidArtifact guidArtA = new DefaultBasicGuidArtifact((BranchId)artifactA.getBranch(), (ArtifactToken)artifactA);
        DefaultBasicGuidArtifact guidArtB = new DefaultBasicGuidArtifact((BranchId)artifactB.getBranch(), (ArtifactToken)artifactB);
        DefaultBasicIdRelation defaultBasicGuidRelation = new DefaultBasicIdRelation(this.relation.getBranch(), this.relation.getRelationType().getId(), this.relation.getId(), this.relation.getGammaId(), guidArtA, guidArtB);
        EventBasicGuidRelation event = new EventBasicGuidRelation(this.relationEventType, (ArtifactId)artifactA, (ArtifactId)artifactB, defaultBasicGuidRelation);
        if (this.relationEventType == RelationEventType.ModifiedRationale) {
            event.setRationale(this.relation.getRationale());
        }
        artifactEvent.getRelations().add(event);
    }

    @Override
    protected ApplicabilityId getApplicabilityId() {
        return this.relation.getApplicabilityId();
    }
}

