/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.relation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.jdk.core.type.CompositeKeyHashMap;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.relation.RelationFilterUtil;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;

public class RelationCache {
    private final CompositeKeyHashMap<ArtifactToken, RelationTypeToken, List<RelationLink>> relationsByType = new CompositeKeyHashMap(1024, true);

    public void deCache(ArtifactToken artifact) {
        Collection removeValues = this.relationsByType.removeValues((Object)artifact);
        if (removeValues != null) {
            for (List relations : removeValues) {
                for (RelationLink relation : relations) {
                    this.removeSingleRelation(artifact, relation);
                }
            }
        }
    }

    private void removeSingleRelation(ArtifactToken artifact, RelationLink relation) {
        ArtifactToken otherArtifact = relation.getOtherSideArtifact((ArtifactId)artifact);
        List relations = (List)this.relationsByType.get((Object)otherArtifact, (Object)relation.getRelationType());
        if (relations != null) {
            relations.remove(relation);
        }
    }

    public void cache(ArtifactToken artifact, RelationLink newRelation) {
        RelationTypeToken relationType = newRelation.getRelationType();
        List<RelationLink> selectedRelations = this.getAllByType(artifact, relationType);
        if (selectedRelations == null) {
            selectedRelations = new CopyOnWriteArrayList<RelationLink>();
            this.relationsByType.put((Object)artifact, (Object)relationType, selectedRelations);
        }
        if (selectedRelations.contains(newRelation)) {
            OseeLog.logf(Activator.class, (Level)Level.SEVERE, (String)"Duplicate relationByType objects for same relation for Relation [%s] Artifact [%s]", (Object[])new Object[]{newRelation, artifact});
        }
        selectedRelations.add(newRelation);
    }

    public List<RelationLink> getAll(ArtifactToken artifact) {
        return this.getRelations(artifact, DeletionFlag.INCLUDE_DELETED);
    }

    public List<RelationLink> getAllByType(ArtifactToken artifact, RelationTypeToken relationType) {
        return (List)this.relationsByType.get((Object)artifact, (Object)relationType);
    }

    public List<RelationLink> getRelations(ArtifactToken artifact, DeletionFlag deletionFlag) {
        ArrayList<RelationLink> linksFound = new ArrayList<RelationLink>();
        RelationFilterUtil.RelationMatcher matcher = RelationFilterUtil.createMatcher(deletionFlag, new RelationFilterUtil.RelationMatcher[0]);
        this.findRelations(linksFound, artifact, matcher);
        return linksFound;
    }

    private void findRelations(Collection<RelationLink> linksFound, ArtifactToken artifact, RelationTypeToken relationType, RelationFilterUtil.RelationMatcher matcher) {
        List sourceLink = (List)this.relationsByType.get((Object)artifact, (Object)relationType);
        RelationFilterUtil.filter(sourceLink, linksFound, matcher);
    }

    private void findRelations(Collection<RelationLink> linksFound, ArtifactToken artifact, RelationFilterUtil.RelationMatcher matcher) {
        List values = this.relationsByType.getValues((Object)artifact);
        if (values != null) {
            for (List linksSource : values) {
                RelationFilterUtil.filter(linksSource, linksFound, matcher);
            }
        }
    }

    public RelationLink getByRelIdOnArtifact(RelationId relLinkId, ArtifactId aArtifactId, ArtifactId bArtifactId, BranchToken branch) {
        RelationFilterUtil.RelationMatcher relIdMatcher = RelationFilterUtil.createFindFirstRelationLinkIdMatcher(relLinkId);
        ArrayList<RelationLink> links = new ArrayList<RelationLink>();
        this.findRelations(links, ArtifactToken.valueOf((ArtifactId)aArtifactId, (BranchToken)branch), relIdMatcher);
        if (links.isEmpty()) {
            this.findRelations(links, ArtifactToken.valueOf((ArtifactId)bArtifactId, (BranchToken)branch), relIdMatcher);
        }
        return links.isEmpty() ? null : (RelationLink)links.iterator().next();
    }

    public RelationLink getLoadedRelation(ArtifactToken artifact, ArtifactId aArtifactId, ArtifactId bArtifactId, RelationTypeToken relationType, DeletionFlag deletionFlag) {
        return this.getLoadedRelation(artifact, aArtifactId.getId(), bArtifactId.getId(), relationType, deletionFlag);
    }

    public RelationLink getLoadedRelation(final ArtifactToken artifact, long aArtifactId, long bArtifactId, RelationTypeToken relationType, DeletionFlag deletionFlag) {
        HashSet<RelationLink> itemsFound = new HashSet<RelationLink>();
        RelationFilterUtil.RelationMatcher artIdMatcher = new RelationFilterUtil.RelationMatcher(){

            @Override
            public boolean matches(RelationLink relation) {
                return relation.getArtifactIdA().equals(artifact) || relation.getArtifactIdB().equals(artifact);
            }

            @Override
            public boolean isFindNextAllowed() {
                return true;
            }
        };
        RelationFilterUtil.RelationMatcher matcher = RelationFilterUtil.createMatcher(deletionFlag, artIdMatcher);
        this.findRelations(itemsFound, artifact, relationType, matcher);
        ArrayList<RelationLink> relations = new ArrayList<RelationLink>();
        for (RelationLink relation : itemsFound) {
            if (!relation.getArtifactIdA().equals(Long.valueOf(aArtifactId)) || !relation.getArtifactIdB().equals(Long.valueOf(bArtifactId))) continue;
            relations.add(relation);
        }
        int size = relations.size();
        if (size > 1) {
            OseeLog.logf(Activator.class, (Level)Level.SEVERE, (String)"Artifact A [%s] has [%d] relations of same type [%s] to Artifact B [%s]", (Object[])new Object[]{artifact, relations.size(), relationType, bArtifactId});
        }
        return size != 0 ? (RelationLink)relations.iterator().next() : null;
    }

    public RelationLink getLoadedRelation(RelationTypeToken relationType, ArtifactId aArtifactId, ArtifactId bArtifactId, BranchId branch) {
        RelationFilterUtil.RelationMatcher bArtIdMatcher = RelationFilterUtil.createFindFirstRelatedArtIdMatcher(bArtifactId, RelationSide.SIDE_B);
        ArrayList<RelationLink> links = new ArrayList<RelationLink>();
        this.findRelations(links, ArtifactToken.valueOf((ArtifactId)aArtifactId, (BranchToken)BranchToken.valueOf((BranchId)branch)), relationType, bArtIdMatcher);
        if (links.isEmpty()) {
            RelationFilterUtil.RelationMatcher aArtIdMatcher = RelationFilterUtil.createFindFirstRelatedArtIdMatcher(aArtifactId, RelationSide.SIDE_A);
            this.findRelations(links, ArtifactToken.valueOf((ArtifactId)bArtifactId, (BranchToken)BranchToken.valueOf((BranchId)branch)), relationType, aArtIdMatcher);
        }
        return links.isEmpty() ? null : (RelationLink)links.iterator().next();
    }
}

