/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal.event;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;

public final class OseeEventThreadFactory
implements ThreadFactory {
    private final List<WeakReference<Thread>> threads;
    private final String threadName;
    private final int priority;

    public OseeEventThreadFactory(String threadName, int priority) {
        this.threadName = threadName;
        this.threads = new CopyOnWriteArrayList<WeakReference<Thread>>();
        this.priority = priority;
    }

    public OseeEventThreadFactory(String name) {
        this(name, 5);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable, String.valueOf(this.threadName) + ":" + this.threads.size());
        thread.setPriority(this.priority);
        this.threads.add(new WeakReference<Thread>(thread));
        return thread;
    }
}

