/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.define.ide.internal.Activator;
import org.eclipse.osee.define.ide.traceability.report.AbstractArtifactRelationReport;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public class ArtifactToRelatedArtifact
extends AbstractArtifactRelationReport {
    public String[] getHeader() {
        ArrayList<String> toReturn = new ArrayList<String>();
        toReturn.add("Name");
        toReturn.add("Related By");
        toReturn.add("Requirement");
        return toReturn.toArray(new String[toReturn.size()]);
    }

    public List<String[]> getRelatedRows(RelationTypeSide[] relations, Artifact artifact) {
        ArrayList<String[]> toReturn = new ArrayList<String[]>();
        int maxSize = 0;
        ArrayList<List> items = new ArrayList<List>();
        RelationTypeSide[] relationTypeSideArray = relations;
        int n = relations.length;
        int n2 = 0;
        while (n2 < n) {
            RelationTypeSide relationEnum = relationTypeSideArray[n2];
            List entries = Named.getNames((Collection)artifact.getRelatedArtifacts(relationEnum));
            items.add(entries);
            maxSize = Math.max(maxSize, entries.size());
            ++n2;
        }
        String unitName = artifact.getName();
        int width = relations.length;
        int rowNumber = 0;
        while (rowNumber < maxSize) {
            String[] row = new String[width + 1];
            row[0] = unitName;
            int index = 0;
            while (index < width) {
                List entry = (List)items.get(index);
                row[index + 1] = rowNumber < entry.size() ? (String)entry.get(rowNumber) : "";
                ++index;
            }
            toReturn.add(row);
            ++rowNumber;
        }
        return toReturn;
    }

    @Override
    public void process(IProgressMonitor monitor) {
        this.notifyOnTableHeader(this.getHeader());
        RelationTypeSide[] relations = this.getRelationsToCheck();
        Artifact[] artifactArray = this.getArtifactsToCheck();
        int n = artifactArray.length;
        int n2 = 0;
        while (n2 < n) {
            Artifact artifact = artifactArray[n2];
            String name = artifact.getName();
            RelationTypeSide[] relationTypeSideArray = relations;
            int n3 = relations.length;
            int n4 = 0;
            while (n4 < n3) {
                RelationTypeSide relationEnum = relationTypeSideArray[n4];
                String typeName = relationEnum.getName();
                try {
                    for (Artifact relArtifact : artifact.getRelatedArtifacts(relationEnum)) {
                        this.notifyOnRowData(artifact, name, typeName, relArtifact.getName());
                    }
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.WARNING, (Throwable)ex);
                }
                ++n4;
            }
            ++n2;
        }
        this.notifyOnEndTable();
    }
}

