/*********************************************************************
 * Copyright (c) 2020 Boeing
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Boeing - initial API and implementation
 **********************************************************************/

package org.eclipse.osee.framework.core.model.change;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;

/**
 * Rollup of ChangeItems for given artifact in change report
 *
 * @author Donald G. Dunne
 */
public class ChangeReportRollup {

   private ArtifactId artId;
   @JsonIgnore
   private ArtifactToken artToken;
   private ArtifactTypeToken artType;
   private List<ChangeItem> changeItems = new ArrayList<ChangeItem>();

   public ChangeReportRollup(ArtifactId art) {
      this.artId = art;
   }

   public ArtifactId getArtId() {
      return artId;
   }

   public void setArtId(ArtifactId artId) {
      this.artId = artId;
   }

   public ArtifactTypeToken getArtType() {
      return artType;
   }

   public void setArtType(ArtifactTypeToken artType) {
      this.artType = artType;
   }

   public List<ChangeItem> getChangeItems() {
      return changeItems;
   }

   public void setChangeItems(List<ChangeItem> changeItems) {
      this.changeItems = changeItems;
   }

   @Override
   public String toString() {
      return "CRR [artId=" + artToken.toStringWithId() + ", " + "items=" + changeItems.size() + " artType=" + artType + "]";
   }

   public ArtifactToken getArtToken() {
      return artToken;
   }

   public void setArtToken(ArtifactToken artToken) {
      this.artToken = artToken;
   }

}
