/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.logger.slf4j.internal;

import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.logger.Log;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Sfl4jLogImpl
implements Log {
    private static final int LOG_ERROR = 1;
    private static final int LOG_WARNING = 2;
    private static final int LOG_INFO = 3;
    private static final int LOG_DEBUG = 4;
    private static final int LOG_TRACE = 5;
    private Logger logger;
    private Marker marker;

    public void start(ComponentContext context) {
        if (this.logger == null) {
            Bundle usingBundle = context.getUsingBundle();
            String symbolicName = null;
            symbolicName = usingBundle != null ? usingBundle.getSymbolicName() : "Osee Log";
            this.logger = LoggerFactory.getLogger((String)symbolicName);
            this.marker = MarkerFactory.getMarker((String)symbolicName);
            this.debug("Logger setup for [%s]", this.logger.getName());
        }
    }

    public void stop() {
        this.logger = null;
        this.marker = null;
    }

    private Logger getLogger() {
        return this.logger;
    }

    public boolean isTraceEnabled() {
        return this.isEnabled(5);
    }

    public void trace(String format, Object ... args) {
        this.trace(null, format, args);
    }

    public void trace(Throwable th, String format, Object ... args) {
        this.logHelper(5, th, format, args);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(4);
    }

    public void debug(String format, Object ... args) {
        this.debug(null, format, args);
    }

    public void debug(Throwable th, String format, Object ... args) {
        this.logHelper(4, th, format, args);
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(3);
    }

    public void info(String format, Object ... args) {
        this.info(null, format, args);
    }

    public void info(Throwable th, String format, Object ... args) {
        this.logHelper(3, th, format, args);
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(2);
    }

    public void warn(String format, Object ... args) {
        this.warn(null, format, args);
    }

    public void warn(Throwable th, String format, Object ... args) {
        this.logHelper(2, th, format, args);
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(1);
    }

    public void error(String format, Object ... args) {
        this.error(null, format, args);
    }

    public void error(Throwable th, String format, Object ... args) {
        this.logHelper(1, th, format, args);
    }

    private boolean isEnabled(int level) {
        boolean result = false;
        Logger logger = this.getLogger();
        if (logger != null) {
            switch (level) {
                case 4: {
                    result = logger.isDebugEnabled();
                    break;
                }
                case 1: {
                    result = logger.isErrorEnabled();
                    break;
                }
                case 2: {
                    result = logger.isWarnEnabled();
                    break;
                }
                case 3: {
                    result = logger.isInfoEnabled();
                    break;
                }
                default: {
                    result = logger.isTraceEnabled();
                }
            }
        }
        return result;
    }

    private void logHelper(int level, Throwable th, String format, Object ... args) {
        this.logHelper(null, level, th, format, args);
    }

    private void logHelper(Object context, int level, Throwable th, String format, Object ... args) {
        String message;
        Logger logger = this.getLogger();
        if (this.isEnabled(level) && (message = Sfl4jLogImpl.safeFormat(format, args)) != null) {
            switch (level) {
                case 4: {
                    logger.debug(this.marker, message, th);
                    break;
                }
                case 1: {
                    logger.error(this.marker, message, th);
                    break;
                }
                case 2: {
                    logger.warn(this.marker, message, th);
                    break;
                }
                case 3: {
                    logger.info(this.marker, message, th);
                    break;
                }
                default: {
                    logger.trace(this.marker, message, th);
                }
            }
        }
    }

    private static String safeFormat(String message, Object ... args) {
        String toReturn;
        try {
            toReturn = String.format(message, args);
        }
        catch (RuntimeException ex) {
            StringBuilder builder = new StringBuilder();
            builder.append("Log message could not be formatted:");
            builder.append(message);
            builder.append(" with the following arguments [");
            builder.append(Collections.toString((String)",", (Object[])args));
            builder.append("].  Cause [");
            builder.append(ex.toString());
            builder.append("]");
            toReturn = builder.toString();
        }
        return toReturn;
    }
}

