/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.operations;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osee.define.ide.traceability.TraceUnitExtensionManager;
import org.eclipse.osee.define.ide.traceability.operations.ResourceToTraceUnit;
import org.eclipse.osee.define.ide.traceability.operations.TraceUnitReportProcessor;
import org.eclipse.osee.define.ide.traceability.operations.TraceUnitToArtifactProcessor;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;

public class TraceUnitFromResourceOperation {
    public static Set<String> getTraceUnitHandlerIds() {
        return TraceUnitExtensionManager.getInstance().getTraceUnitHandlerIds();
    }

    private static ResourceToTraceUnit getResourceToTestUnit(Iterable<URI> sources, boolean isRecursive, boolean isFileWithMultiplePaths, boolean addGuidToSourceFile, boolean includeImpd, String ... testUnitTraceIds) {
        TraceUnitFromResourceOperation.checkSourceArgument(sources);
        TraceUnitFromResourceOperation.checkTraceUnitHandlerIdsArgument(testUnitTraceIds);
        ResourceToTraceUnit operation = new ResourceToTraceUnit(sources, isRecursive, isFileWithMultiplePaths, includeImpd);
        TraceUnitExtensionManager traceManager = TraceUnitExtensionManager.getInstance();
        String[] stringArray = testUnitTraceIds;
        int n = testUnitTraceIds.length;
        int n2 = 0;
        while (n2 < n) {
            String traceUnitHandlerId = stringArray[n2];
            TraceUnitExtensionManager.TraceHandler handler = traceManager.getTraceUnitHandlerById(traceUnitHandlerId);
            if (handler != null) {
                operation.addTraceUnitHandler(handler.getLocator(), handler.getParser());
            }
            ++n2;
        }
        return operation;
    }

    public static void printTraceFromTestUnits(IProgressMonitor monitor, Iterable<URI> sources, boolean isRecursive, boolean isFileWithMultiplePaths, boolean addGuidToSourceFile, boolean includeImpd, String ... traceUnitHandlerIds) {
        ResourceToTraceUnit operation = TraceUnitFromResourceOperation.getResourceToTestUnit(sources, isRecursive, isFileWithMultiplePaths, addGuidToSourceFile, includeImpd, traceUnitHandlerIds);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        operation.addTraceProcessor(new TraceUnitReportProcessor());
        operation.execute(monitor);
    }

    public static void importTraceFromTestUnits(IProgressMonitor monitor, Iterable<URI> sources, boolean isRecursive, boolean isFileWithMultiplePaths, BranchId importToBranch, boolean addGuidToSourceFile, boolean includeImpd, String ... traceUnitHandlerIds) {
        TraceUnitFromResourceOperation.checkBranchArguments(importToBranch);
        ResourceToTraceUnit operation = TraceUnitFromResourceOperation.getResourceToTestUnit(sources, isRecursive, isFileWithMultiplePaths, addGuidToSourceFile, includeImpd, traceUnitHandlerIds);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        operation.addTraceProcessor(new TraceUnitToArtifactProcessor(importToBranch, addGuidToSourceFile));
        operation.execute(monitor);
    }

    private static void checkTraceUnitHandlerIdsArgument(String ... traceUnitHandlerIds) {
        if (traceUnitHandlerIds == null) {
            throw new OseeArgumentException("Test unit trace ids was null", new Object[0]);
        }
        if (traceUnitHandlerIds.length == 0) {
            throw new OseeArgumentException("Test unit trace ids was empty", new Object[0]);
        }
        try {
            Set<String> ids = TraceUnitFromResourceOperation.getTraceUnitHandlerIds();
            List notFound = Collections.setComplement(Arrays.asList(traceUnitHandlerIds), ids);
            if (!notFound.isEmpty()) {
                throw new OseeArgumentException("Invalid test unit trace id(s) [%s]", new Object[]{notFound});
            }
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    private static void checkSourceArgument(Iterable<URI> sources) {
        if (sources == null) {
            throw new OseeArgumentException("Source was null", new Object[0]);
        }
        try {
            for (URI source : sources) {
                IFileStore fileStore = EFS.getStore((URI)source);
                IFileInfo fileInfo = fileStore.fetchInfo();
                if (fileInfo.exists()) continue;
                throw new OseeArgumentException("Unable to access source: [%s]", new Object[]{source});
            }
        }
        catch (CoreException ex) {
            throw new OseeArgumentException((Throwable)ex);
        }
    }

    private static void checkBranchArguments(BranchId importToBranch) {
        if (importToBranch == null) {
            throw new OseeArgumentException("Branch to import into was null", new Object[0]);
        }
        if (!BranchManager.getType((BranchId)importToBranch).isWorkingBranch()) {
            throw new OseeArgumentException("Branch to import into was not a working branch: [%s]", new Object[]{importToBranch});
        }
    }
}

