/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.config.AtsAttributeValueColumn;
import org.eclipse.osee.ats.api.data.AtsUserGroups;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsAttributeValueColumn;
import org.eclipse.osee.ats.ide.world.AtsWorldEditorItems;
import org.eclipse.osee.ats.ide.world.IAtsWorldEditorItem;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.exception.OseeTypeDoesNotExist;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.attribute.AttributeTypeManager;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.SkynetXViewerFactory;

public class WorldXViewerUtil {
    public static void registerOtherColumns(SkynetXViewerFactory factory) {
        WorldXViewerUtil.registerAtsAttributeColumns(factory);
        WorldXViewerUtil.registerPluginColumns(factory);
        WorldXViewerUtil.registerConfigurationsColumns(factory);
    }

    public static void registerPluginColumns(SkynetXViewerFactory factory) {
        try {
            for (IAtsWorldEditorItem item : AtsWorldEditorItems.getItems()) {
                Collection<IUserGroupArtifactToken> itemGroups = item.getUserGroups();
                if (!AtsApiService.get().userService().isInUserGroup(itemGroups.toArray(new IUserGroupArtifactToken[itemGroups.size()]))) continue;
                for (XViewerColumn xCol : item.getXViewerColumns()) {
                    factory.registerColumns(new XViewerColumn[]{xCol});
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public static void registerAtsAttributeColumns(SkynetXViewerFactory factory) {
        try {
            if (AtsApiService.get().userService().isInUserGroup(new IUserGroupArtifactToken[]{AtsUserGroups.AtsAddAttrColumns})) {
                for (AttributeTypeToken attributeType : AttributeTypeManager.getAllTypes()) {
                    if (!attributeType.getName().startsWith("ats.")) continue;
                    factory.registerColumns(new XViewerColumn[]{SkynetXViewerFactory.getAttributeColumn((AttributeTypeToken)attributeType)});
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public static void registerConfigurationsColumns(SkynetXViewerFactory factory) {
        List<XViewerAtsAttributeValueColumn> configColumns = WorldXViewerUtil.getConfigurationColumns();
        for (XViewerAtsAttributeValueColumn col : configColumns) {
            factory.registerColumns(new XViewerColumn[]{col});
        }
    }

    public static List<XViewerAtsAttributeValueColumn> getConfigurationColumns() {
        List columns = AtsApiService.get().getConfigService().getConfigurations().getViews().getAttrColumns();
        ArrayList<XViewerAtsAttributeValueColumn> configColumns = new ArrayList<XViewerAtsAttributeValueColumn>();
        for (AtsAttributeValueColumn column : columns) {
            try {
                AttributeTypeGeneric attrType = null;
                try {
                    attrType = AttributeTypeManager.getAttributeType((Long)column.getAttrTypeId());
                }
                catch (OseeTypeDoesNotExist oseeTypeDoesNotExist) {
                    continue;
                }
                XViewerAtsAttributeValueColumn valueColumn = new XViewerAtsAttributeValueColumn((AttributeTypeToken)attrType, column.getWidth(), AtsEditors.getXViewerAlign(column.getAlign()), column.isVisible(), SortDataType.valueOf((String)column.getSortDataType()), column.isColumnMultiEdit(), column.getDescription());
                valueColumn.setBooleanNotSetShow(column.getBooleanNotSetShow());
                valueColumn.setBooleanOnFalseShow(column.getBooleanOnFalseShow());
                valueColumn.setBooleanOnTrueShow(column.getBooleanOnTrueShow());
                valueColumn.setActionRollup(column.isActionRollup());
                valueColumn.setInheritParent(column.isInheritParent());
                configColumns.add(valueColumn);
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return configColumns;
    }

    public static XViewerColumn getConfigColumn(String columnId, List<XViewerAtsAttributeValueColumn> configCols) {
        for (XViewerAtsAttributeValueColumn col : configCols) {
            if (!col.getId().equals(columnId)) continue;
            return col;
        }
        return null;
    }

    public static void addColumn(SkynetXViewerFactory factory, XViewerColumn taskCol, int width, List<XViewerColumn> sprintCols) {
        XViewerColumn newCol = taskCol.copy();
        newCol.setShow(true);
        newCol.setWidth(width);
        factory.registerColumns(new XViewerColumn[]{newCol});
        sprintCols.add(newCol);
    }
}

