/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task.related;

import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;

public abstract class AbstractShowRelatedAction
extends Action {
    private final ISelectedAtsArtifacts selectedAtsArtifacts;

    public AbstractShowRelatedAction(String name, ISelectedAtsArtifacts selectedAtsArtifacts) {
        super(name, 1);
        this.selectedAtsArtifacts = selectedAtsArtifacts;
        boolean shouldEnable = false;
        try {
            shouldEnable = !selectedAtsArtifacts.getSelectedTaskArtifacts().isEmpty();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        this.setEnabled(shouldEnable);
    }

    protected boolean isAutoGenRelatedArtTasks(Collection<IAtsTask> tasks) {
        try {
            if (!AtsApiService.get().getTaskRelatedService().isAutoGenChangeReportRelatedTasks(tasks)) {
                AWorkbench.popup((String)"Tasks must be Auto Generated Change Report Related Tasks");
                return false;
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return true;
    }

    protected Collection<IAtsTask> getSelectedTasks() {
        return Collections.castAll(AbstractShowRelatedAction.getSelectedTaskArtifacts(this.selectedAtsArtifacts));
    }

    protected static Collection<TaskArtifact> getSelectedTaskArtifacts(ISelectedAtsArtifacts selectedAtsArtifacts) {
        try {
            return selectedAtsArtifacts.getSelectedTaskArtifacts();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return java.util.Collections.emptyList();
        }
    }

    public static boolean isValid(ISelectedAtsArtifacts selectedAtsArtifacts) {
        for (TaskArtifact task : AbstractShowRelatedAction.getSelectedTaskArtifacts(selectedAtsArtifacts)) {
            if (AbstractShowRelatedAction.isValid(task)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(TaskArtifact task) {
        block4: {
            if (AtsApiService.get().getTaskRelatedService().isAutoGenChangeReportRelatedTask((IAtsTask)task)) break block4;
            return false;
        }
        try {
            TeamWorkFlowArtifact teamArt = task.getParentTeamWorkflow();
            if (AtsApiService.get().getProgramService().getProgram((IAtsWorkItem)teamArt) == null) {
                return false;
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return true;
    }
}

