/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.core.util.AbstractRelationResolverServiceImpl;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.IRelationLink;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.ArtifactReadableImpl;

public class AtsRelationResolverServiceImpl
extends AbstractRelationResolverServiceImpl {
    private final AtsApiIde atsApi;

    public AtsRelationResolverServiceImpl(AtsApiIde atsClient) {
        this.atsApi = atsClient;
    }

    public Collection<ArtifactToken> getRelated(ArtifactId artifact, RelationTypeSide relationType) {
        ArrayList<ArtifactToken> results = new ArrayList<ArtifactToken>();
        Artifact useArt = this.getArtifact(artifact);
        if (useArt != null) {
            for (Artifact art : useArt.getRelatedArtifacts(relationType)) {
                results.add((ArtifactToken)art);
            }
        }
        return results;
    }

    public <T extends IAtsObject> Collection<T> getRelated(IAtsObject atsObject, RelationTypeSide relationType, Class<T> clazz) {
        return this.getRelated(atsObject, relationType, DeletionFlag.EXCLUDE_DELETED, clazz);
    }

    public <T extends IAtsObject> Collection<T> getRelated(IAtsObject atsObject, RelationTypeSide relationType, DeletionFlag flag, Class<T> clazz) {
        ArrayList<IAtsObject> results = new ArrayList<IAtsObject>();
        if (atsObject == null || atsObject.isInvalid()) {
            return results;
        }
        Artifact useArt = this.getArtifact(atsObject);
        if (useArt != null) {
            for (Artifact art : useArt.getRelatedArtifacts(relationType, flag)) {
                IAtsObject object = AtsObjects.getAtsObject((ArtifactToken)art, (AtsApi)this.atsApi);
                if (object == null) continue;
                results.add(object);
            }
        }
        return results;
    }

    public Artifact getArtifact(Object object) {
        Artifact useArt = null;
        if (object instanceof Artifact) {
            useArt = (Artifact)this.atsApi.getQueryService().getArtifact((ArtifactId)((Artifact)object));
        } else if (object instanceof IAtsObject) {
            IAtsObject atsObject = (IAtsObject)object;
            useArt = atsObject.getStoreObject() instanceof Artifact ? (Artifact)this.atsApi.getQueryService().getArtifact(atsObject) : (Artifact)this.atsApi.getQueryService().getArtifact(atsObject.getId());
        } else if (object instanceof ArtifactId) {
            useArt = (Artifact)this.atsApi.getQueryService().getArtifact(((ArtifactId)object).getId());
        }
        return useArt;
    }

    public boolean areRelated(ArtifactId artifact1, RelationTypeSide relationType, ArtifactId artifact2) {
        boolean related = false;
        Artifact useArt1 = this.getArtifact(artifact1);
        Artifact useArt2 = this.getArtifact(artifact2);
        if (useArt1 != null && useArt2 != null) {
            related = useArt1.isRelated(relationType, useArt2);
        }
        return related;
    }

    public boolean areRelated(IAtsObject atsObject1, RelationTypeSide relationType, IAtsObject atsObject2) {
        boolean related = false;
        Artifact useArt1 = this.getArtifact(atsObject1);
        Artifact useArt2 = this.getArtifact(atsObject2);
        if (useArt1 != null && useArt2 != null) {
            related = useArt1.isRelated(relationType, useArt2);
        }
        return related;
    }

    public ArtifactToken getRelatedOrNull(ArtifactId artifact, RelationTypeSide relationType) {
        Artifact related = null;
        Artifact art = this.getArtifact(artifact);
        if (art != null) {
            try {
                related = art.getRelatedArtifact(relationType);
            }
            catch (ArtifactDoesNotExist artifactDoesNotExist) {}
        }
        return related;
    }

    public ArtifactToken getRelatedOrSentinel(ArtifactId artifact, RelationTypeSide relationType) {
        ArtifactReadableImpl related = ArtifactReadable.SENTINEL;
        Artifact art = this.getArtifact(artifact);
        if (art != null) {
            try {
                related = art.getRelatedArtifact(relationType);
            }
            catch (ArtifactDoesNotExist artifactDoesNotExist) {}
        }
        return related;
    }

    public <T> T getRelatedOrNull(IAtsObject atsObject, RelationTypeSide relationType, Class<T> clazz) {
        IAtsObject related = null;
        Artifact art = this.getArtifact(atsObject);
        if (art != null) {
            try {
                IAtsObject object;
                Artifact artifact = art.getRelatedArtifact(relationType);
                if (artifact != null && (object = AtsObjects.getAtsObject((ArtifactToken)artifact, (AtsApi)this.atsApi)) != null) {
                    related = object;
                }
            }
            catch (ArtifactDoesNotExist artifactDoesNotExist) {}
        }
        return (T)related;
    }

    public int getRelatedCount(IAtsWorkItem workItem, RelationTypeSide relationType) {
        Artifact artifact = this.getArtifact(workItem);
        int count = 0;
        if (artifact != null) {
            count = artifact.getRelatedArtifactsCount(relationType);
        }
        return count;
    }

    public ArtifactToken getRelatedOrNull(IAtsObject atsObject, RelationTypeSide relationSide) {
        Artifact art = this.getArtifact(atsObject);
        if (art != null) {
            return art.getRelatedArtifactOrNull(relationSide);
        }
        return null;
    }

    public ArtifactToken getRelatedOrSentinel(IAtsObject atsObject, RelationTypeSide relationSide) {
        ArtifactReadableImpl related = ArtifactReadable.SENTINEL;
        Artifact art = this.getArtifact(atsObject);
        if (art != null) {
            related = art.getRelatedArtifactOrNull(relationSide);
            return related == null ? ArtifactReadable.SENTINEL : related;
        }
        return ArtifactReadable.SENTINEL;
    }

    public List<ArtifactToken> getRelatedArtifacts(IAtsWorkItem workItem, RelationTypeSide relationTypeSide) {
        Artifact artifact = this.getArtifact(workItem);
        return Collections.castAll(this.getRelated((ArtifactId)artifact, relationTypeSide));
    }

    public Collection<ArtifactToken> getRelated(ArtifactId artifact, RelationTypeSide relationType, ArtifactTypeToken artifactType) {
        LinkedList<ArtifactToken> results = new LinkedList<ArtifactToken>();
        Artifact art = this.getArtifact(artifact);
        for (ArtifactToken related : art.getRelatedArtifacts(relationType)) {
            if (!this.atsApi.getQueryService().getArtifact((ArtifactId)related).isOfType(new ArtifactTypeId[]{artifactType})) continue;
            results.add(related);
        }
        return results;
    }

    public Collection<ArtifactToken> getRelatedArtifacts(ArtifactId artifact, RelationTypeSide relationTypeSide) {
        return this.getRelated(artifact, relationTypeSide);
    }

    public int getRelatedCount(ArtifactToken artifact, RelationTypeSide relationTypeSide) {
        Artifact art = this.getArtifact(artifact);
        return art.getRelatedArtifactsCount(relationTypeSide);
    }

    public Collection<Long> getRelatedIds(ArtifactId artifact, RelationTypeSide relationTypeSide) {
        LinkedList<Long> related = new LinkedList<Long>();
        Artifact art = this.getArtifact(artifact);
        for (Artifact rel : art.getRelatedArtifacts(relationTypeSide)) {
            related.add(rel.getId());
        }
        return related;
    }

    public Collection<IRelationLink> getRelations(ArtifactId artifact, RelationTypeSide relationTypeSide) {
        Artifact art = this.getArtifact(artifact);
        return Collections.castAll((Collection)art.getRelations(relationTypeSide));
    }
}

