/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.core.config.TeamDefinitionSorter;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.XComboViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.swt.widgets.Composite;

public class XTeamDefinitionCombo
extends XComboViewer {
    public static final String WIDGET_ID = XTeamDefinitionCombo.class.getSimpleName();
    private Artifact selectedTeamDef = null;

    public XTeamDefinitionCombo() {
        super("Team Definition", 8);
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        super.createControls(parent, horizontalSpan);
        List teamDefs = null;
        try {
            teamDefs = AtsApiService.get().getTeamDefinitionService().getTeamDefinitions(Active.Active);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Error loading team definitions", (Throwable)ex);
        }
        if (teamDefs != null) {
            ArrayList sortedTeamDefs = new ArrayList();
            sortedTeamDefs.addAll(teamDefs);
            Collections.sort(sortedTeamDefs, new TeamDefinitionSorter());
            this.getComboViewer().setInput(sortedTeamDefs);
            ArrayList<String> defaultSelection = new ArrayList<String>();
            defaultSelection.add("--select--");
            this.setSelected(defaultSelection);
            this.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    XTeamDefinitionCombo.this.selectedTeamDef = AtsApiService.get().getQueryServiceIde().getArtifact(XTeamDefinitionCombo.this.getSelected());
                }
            });
        }
    }

    public Artifact getSelectedTeamDef() {
        return this.selectedTeamDef;
    }
}

