/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.AITreeContentProvider;
import org.eclipse.osee.ats.ide.util.widgets.dialog.AtsObjectNameSorter;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.util.IsEnabled;
import org.eclipse.osee.framework.ui.skynet.widgets.GenericXWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidgetUtility;
import org.eclipse.osee.framework.ui.skynet.widgets.checkbox.CheckBoxStateFilteredTreeViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.checkbox.CheckBoxStateTreeLabelProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.checkbox.ICheckBoxStateTreeListener;
import org.eclipse.osee.framework.ui.skynet.widgets.checkbox.ICheckBoxStateTreeViewer;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.FontManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class XActionableItemWidget
extends GenericXWidget
implements IsEnabled {
    public static final String WIDGET_ID = XActionableItemWidget.class.getSimpleName();
    protected CheckBoxStateFilteredTreeViewer<IAtsActionableItem> treeViewer;
    public static String NAME = "Actionable Item(s)";
    protected final AtsApi atsApi = AtsApiService.get();
    private Composite mainComp;
    private Text descriptionLabel;

    public XActionableItemWidget() {
        super(NAME);
    }

    public Control getControl() {
        return null;
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        this.mainComp = new Composite(parent, 0x800000);
        this.mainComp.setLayoutData((Object)new GridData(768));
        this.mainComp.setLayout((Layout)new GridLayout(1, true));
        if (this.toolkit != null) {
            this.toolkit.paintBordersFor(this.mainComp);
        }
        this.labelWidget = new Label(this.mainComp, 0);
        this.labelWidget.setText(String.valueOf(this.getLabel()) + ":");
        if (this.getToolTip() != null) {
            this.labelWidget.setToolTipText(this.getToolTip());
        }
        try {
            Composite tableComp = new Composite(this.mainComp, 2048);
            GridData gd = new GridData(768);
            tableComp.setLayoutData((Object)gd);
            tableComp.setLayout((Layout)ALayout.getZeroMarginLayout());
            if (this.toolkit != null) {
                this.toolkit.paintBordersFor(tableComp);
            }
            Pair<CheckBoxStateFilteredTreeViewer<IAtsActionableItem>, Text> results = this.createActionableItemTreeViewer(tableComp, this.getSelectableAis());
            this.treeViewer = (CheckBoxStateFilteredTreeViewer)results.getFirst();
            this.treeViewer.setEnabledChecker((IsEnabled)this);
            this.treeViewer.addCheckListener((ICheckBoxStateTreeListener)new CheckStateListener());
            if (this.getInitialAias() != null) {
                this.treeViewer.setChecked(this.getInitialAias());
            }
            this.refresh();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        XWidgetUtility.setLabelFontsBold((Control)this.labelWidget, (Font)FontManager.getDefaultLabelFont());
    }

    private Collection<IAtsActionableItem> getSelectableAis() {
        return null;
    }

    private Collection<IAtsActionableItem> getInitialAias() {
        return Collections.emptyList();
    }

    public Set<IAtsActionableItem> getSelectedIAtsActionableItems() {
        HashSet<IAtsActionableItem> selected = new HashSet<IAtsActionableItem>();
        for (Object obj : this.treeViewer.getChecked()) {
            if (obj instanceof IAtsActionableItem) {
                selected.add((IAtsActionableItem)obj);
                continue;
            }
            if (!(obj instanceof ActionableItem)) continue;
            ActionableItem ai = (ActionableItem)obj;
            selected.add((IAtsActionableItem)this.atsApi.getQueryService().getConfigItem(ai.getId()));
        }
        return selected;
    }

    public Pair<CheckBoxStateFilteredTreeViewer<IAtsActionableItem>, Text> createActionableItemTreeViewer(Composite comp, Collection<IAtsActionableItem> selectableAis) {
        Composite aiComp = new Composite(comp, 0);
        aiComp.setLayout((Layout)new GridLayout(1, false));
        aiComp.setLayoutData((Object)new GridData(1808));
        new Label(aiComp, 0).setText("Select Actionable Items:");
        final CheckBoxStateFilteredTreeViewer treeViewer = new CheckBoxStateFilteredTreeViewer(aiComp, 2824);
        treeViewer.getViewer().getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        treeViewer.getViewer().setContentProvider((IContentProvider)new AITreeContentProvider(Active.Active));
        treeViewer.getViewer().setLabelProvider((IBaseLabelProvider)new AITreeLabelProvider((ICheckBoxStateTreeViewer)treeViewer));
        try {
            if (selectableAis == null) {
                LinkedList<ActionableItem> activeActionableItemTree = new LinkedList<ActionableItem>();
                AtsConfigurations configs = AtsApiService.get().getConfigService().getConfigurations();
                for (Long aiId : ((ActionableItem)configs.getIdToAi().get(configs.getTopActionableItem().getId())).getChildren()) {
                    ActionableItem ai = (ActionableItem)configs.getIdToAi().get(aiId);
                    if (!ai.isActive()) continue;
                    activeActionableItemTree.add(ai);
                }
                treeViewer.getViewer().setInput(activeActionableItemTree);
                if (activeActionableItemTree.size() == 1) {
                    treeViewer.expandOneLevel();
                }
            } else {
                treeViewer.getViewer().setInput(selectableAis);
                if (selectableAis.size() == 1) {
                    treeViewer.expandOneLevel();
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        treeViewer.getViewer().setComparator((ViewerComparator)new AtsObjectNameSorter());
        GridData gridData1 = new GridData(1808);
        gridData1.heightHint = 200;
        treeViewer.setLayoutData((Object)gridData1);
        new Label(aiComp, 0).setText("Description of highlighted Actionable Item (if any):");
        this.descriptionLabel = new Text(aiComp, 2112);
        gridData1 = new GridData(1808);
        gridData1.heightHint = 15;
        this.descriptionLabel.setLayoutData((Object)gridData1);
        this.descriptionLabel.setEnabled(false);
        Button deselectAll = new Button(aiComp, 8);
        deselectAll.setText("De-Select All");
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                treeViewer.deSelectAll();
            }
        });
        return new Pair((Object)treeViewer, (Object)this.descriptionLabel);
    }

    public boolean isEnabled(Object obj) {
        if (obj instanceof IAtsActionableItem) {
            return ((IAtsActionableItem)obj).isActive() && ((IAtsActionableItem)obj).isActionable();
        }
        return false;
    }

    public IStatus isValid() {
        Status returnStatus = new Status(0, ((Object)((Object)this)).getClass().getSimpleName(), "");
        try {
            if (this.isRequiredEntry() && this.getSelectedIAtsActionableItems().isEmpty()) {
                returnStatus = new Status(4, ((Object)((Object)this)).getClass().getSimpleName(), "Actionable Item(s) must be selected.");
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return new Status(4, ((Object)((Object)this)).getClass().getSimpleName(), ex.getLocalizedMessage());
        }
        return returnStatus;
    }

    public CheckBoxStateFilteredTreeViewer<IAtsActionableItem> getTreeViewer() {
        return this.treeViewer;
    }

    public static class AITreeLabelProvider
    extends CheckBoxStateTreeLabelProvider {
        public AITreeLabelProvider(ICheckBoxStateTreeViewer treeViewer) {
            super(treeViewer);
        }

        protected boolean isEnabled(Object element) {
            IAtsActionableItem ai;
            boolean enabled = false;
            if (element instanceof IAtsActionableItem && (ai = (IAtsActionableItem)element).isActionable()) {
                enabled = true;
            }
            return enabled;
        }
    }

    private class CheckStateListener
    implements ICheckBoxStateTreeListener {
        private CheckStateListener() {
        }

        public void checkStateChanged(Object obj) {
            if (XActionableItemWidget.this.descriptionLabel != null) {
                Collection checked = XActionableItemWidget.this.treeViewer.getChecked();
                if (checked.isEmpty()) {
                    XActionableItemWidget.this.descriptionLabel.setText("");
                } else {
                    IAtsActionableItem ai = (IAtsActionableItem)checked.iterator().next();
                    XActionableItemWidget.this.descriptionLabel.setText(ai.getDescription());
                }
            }
        }
    }
}

