/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.ev;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.skynet.artifact.massEditor.MassArtifactEditor;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.swt.ImageManager;

public class OpenWorkPackageByIdAction
extends Action {
    public OpenWorkPackageByIdAction() {
        this("Open Work Package by ID(s)");
    }

    public OpenWorkPackageByIdAction(String name) {
        super(name);
        this.setToolTipText(this.getText());
    }

    public void run() {
        final EntryDialog dialog = new EntryDialog(this.getText(), "Enter Work Package id, activity id or financial id");
        if (dialog.open() == 0) {
            final LinkedList<String> ids = new LinkedList<String>();
            String[] stringArray = dialog.getEntry().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                str = str.replaceAll("^\\s+", "");
                if (Strings.isNumeric((String)(str = str.replaceAll("\\s+$", "")))) {
                    ids.add(str);
                }
                Job searchWps = new Job(this.getText()){

                    protected IStatus run(IProgressMonitor monitor) {
                        LinkedList results = new LinkedList();
                        if (!ids.isEmpty()) {
                            results.addAll(ArtifactQuery.getArtifactListFromAttributeValues((AttributeTypeId)AtsAttributeTypes.ActivityId, (Collection)ids, (BranchId)AtsApiService.get().getAtsBranch(), (int)5));
                            results.addAll(ArtifactQuery.getArtifactListFromAttributeValues((AttributeTypeId)AtsAttributeTypes.CognosUniqueId, (Collection)ids, (BranchId)AtsApiService.get().getAtsBranch(), (int)5));
                        }
                        if (results.isEmpty()) {
                            AWorkbench.popup((String)("No Work Packages found with id(s): " + dialog.getEntry()));
                        } else {
                            MassArtifactEditor.editArtifacts((String)this.getName(), results, (XNavigateComposite.TableLoadOption[])new XNavigateComposite.TableLoadOption[0]);
                        }
                        return Status.OK_STATUS;
                    }
                };
                Jobs.startJob((Job)searchWps, (boolean)true);
                ++n2;
            }
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.WORK_PACKAGE);
    }
}

