/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.column.AbstractNumericTotalColumn;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;

public class RemainingPointsWorkflowColumn
extends AbstractNumericTotalColumn {
    private static final String CALCULATION_STR = "Points - (Points * (Percent Complete from Workflow / 100))";
    private static RemainingPointsWorkflowColumn instance = new RemainingPointsWorkflowColumn();

    public static RemainingPointsWorkflowColumn getInstance() {
        return instance;
    }

    private RemainingPointsWorkflowColumn() {
        super("ats.column.remainingPointsWorkflow", "Remaining Points - Workflow", "Points that remain to complete the changes based on percent complete set on workflow.", CALCULATION_STR, (AttributeTypeToken)AtsAttributeTypes.Points);
    }

    public RemainingPointsWorkflowColumn copy() {
        RemainingPointsWorkflowColumn newXCol = new RemainingPointsWorkflowColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    @Override
    protected int getPercentComplete(IAtsWorkItem workItem) {
        return (Integer)AtsApiService.get().getQueryServiceIde().getArtifact(workItem).getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.PercentComplete, (Object)0);
    }
}

